/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.animation;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import tkachgeek.tkachutils.animation.AnimationProperties;
import tkachgeek.tkachutils.animation.ExecutionMode;

public class ObjectAnimation<T> {
    AnimationProperties properties;
    BiConsumer<Double, T> action;
    Supplier<T> before = null;
    Consumer<T> after = null;
    T object;

    private ObjectAnimation(Supplier<T> before) {
        this.before = before;
    }

    public static <T> ObjectAnimation<T> before(Supplier<T> before) {
        return new ObjectAnimation<T>(before);
    }

    public ObjectAnimation<T> setProperties(AnimationProperties properties) {
        this.properties = properties;
        return this;
    }

    public ObjectAnimation<T> setAction(BiConsumer<Double, T> action) {
        this.action = action;
        return this;
    }

    public void start(JavaPlugin plugin, ExecutionMode mode) {
        this.runBefore(plugin, mode);
        this.runMain(plugin, mode);
        this.runAfter(plugin, mode);
    }

    private void runAfter(JavaPlugin plugin, ExecutionMode mode) {
        if (this.after == null) {
            return;
        }
        switch (mode) {
            case ASYNC: 
            case INSTANT_ASYNC: {
                Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, () -> this.after.accept(this.object), this.properties.frameDelayInTicks() + 1L);
                break;
            }
            case SYNC: 
            case INSTANT_SYNC: {
                Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> this.after.accept(this.object), this.properties.frameDelayInTicks() + 1L);
            }
        }
    }

    private void runMain(JavaPlugin plugin, ExecutionMode mode) {
        while (this.properties.hasNextFrame()) {
            double finalCurrent = this.properties.nextFrame();
            switch (mode) {
                case ASYNC: 
                case INSTANT_ASYNC: {
                    Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, () -> this.action.accept(finalCurrent, (Double)this.object), this.properties.frameDelayInTicks());
                    break;
                }
                case SYNC: 
                case INSTANT_SYNC: {
                    Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> this.action.accept(finalCurrent, (Double)this.object), this.properties.frameDelayInTicks());
                }
            }
        }
    }

    private void runBefore(JavaPlugin plugin, ExecutionMode mode) {
        if (this.before == null) {
            return;
        }
        switch (mode) {
            case ASYNC: {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                    this.object = this.before.get();
                });
                break;
            }
            case SYNC: {
                Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                    this.object = this.before.get();
                });
                break;
            }
            case INSTANT_ASYNC: 
            case INSTANT_SYNC: {
                this.object = this.before.get();
            }
        }
    }

    public ObjectAnimation<T> after(Consumer<T> after) {
        this.after = after;
        return this;
    }
}

