/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.datetime;

import java.io.Serializable;

public class Expireable
implements Serializable {
    long time = 0L;
    long expires = 0L;

    public Expireable() {
    }

    public Expireable(long ms, long lastTime) {
        this(ms);
        this.time = lastTime;
    }

    public Expireable(long ms) {
        this.expires = ms;
    }

    public boolean isExpiredAndReset() {
        if (this.isExpired()) {
            this.reset();
            return true;
        }
        return false;
    }

    public boolean isExpired() {
        return this.time + this.expires < System.currentTimeMillis();
    }

    public void reset() {
        this.time = System.currentTimeMillis();
    }

    public void expireAfter(long ms) {
        this.expires = ms;
    }

    public long getLastTime() {
        return this.time;
    }

    public long getExpiresTime() {
        return this.expires;
    }

    public long getExpireAfterTime() {
        return this.time + this.expires - System.currentTimeMillis();
    }

    public double getPercent() {
        return (double)(System.currentTimeMillis() - this.time) / (double)this.expires;
    }

    public double getPercentBounded() {
        return Math.min(1.0, (double)(System.currentTimeMillis() - this.time) / (double)this.expires);
    }

    public double getRevertPercentBounded() {
        return 1.0 - this.getPercentBounded();
    }
}

