/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.datetime;

import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;

public class TimeFormatter {
    public static final SimpleDateFormat MM_SS_TIME_FORMAT = new SimpleDateFormat("mm:ss");
    public static final SimpleDateFormat HH_MM_SS_TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    public static final SimpleDateFormat MM_SS_TIME_FORMAT_UTC = new SimpleDateFormat("mm:ss");
    public static final SimpleDateFormat HH_MM_SS_TIME_FORMAT_UTC = new SimpleDateFormat("HH:mm:ss");
    public static final SimpleDateFormat FULL_DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    private static final String formatted_time_days = "\u0434";
    private static final String formatted_time_hours = "\u0447";
    private static final String formatted_time_minutes = "\u043c\u0438\u043d";
    private static final String formatted_time_seconds = "\u0441\u0435\u043a";

    public static String formatFull(long millis) {
        return TimeFormatter.format(millis, FULL_DATE_FORMAT);
    }

    public static String formatHours(long millis) {
        return TimeFormatter.format(millis, HH_MM_SS_TIME_FORMAT);
    }

    public static String format(long millis, SimpleDateFormat format) {
        return format.format(millis);
    }

    public static String formatHoursUTC(long millis) {
        return TimeFormatter.format(millis, HH_MM_SS_TIME_FORMAT_UTC);
    }

    public static String formatNowFull() {
        return TimeFormatter.format(System.currentTimeMillis(), FULL_DATE_FORMAT);
    }

    public static String formatNowHours() {
        return TimeFormatter.format(System.currentTimeMillis(), HH_MM_SS_TIME_FORMAT);
    }

    public static String formatNow(String format) {
        return TimeFormatter.format(System.currentTimeMillis(), format);
    }

    public static String format(long millis, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(new Date(millis));
    }

    public static String formatNow() {
        return TimeFormatter.format(System.currentTimeMillis());
    }

    public static String format(long millis) {
        return TimeFormatter.format(millis, MM_SS_TIME_FORMAT);
    }

    public static String formatUTC(long millis) {
        return TimeFormatter.format(millis, MM_SS_TIME_FORMAT_UTC);
    }

    public static String getFormattedTime(@NotNull Duration duration, int timeParamsCount, String formatted_time_days, String formatted_time_hours, String formatted_time_minutes, String formatted_time_seconds) {
        StringBuilder formattedTime = new StringBuilder();
        long days = Math.abs(duration.toDaysPart());
        long hours = Math.abs(duration.toHoursPart());
        long minutes = Math.abs(duration.toMinutesPart());
        long seconds = Math.abs(duration.toSecondsPart());
        if (seconds == 0L) {
            seconds = 1L;
        }
        if (days > 0L) {
            formattedTime.append(days).append(formatted_time_days);
            --timeParamsCount;
        }
        if (hours > 0L && timeParamsCount > 0) {
            if (formattedTime.length() > 0) {
                formattedTime.append(" ");
            }
            formattedTime.append(hours).append(formatted_time_hours);
            --timeParamsCount;
        }
        if (minutes > 0L && timeParamsCount > 0) {
            if (formattedTime.length() > 0) {
                formattedTime.append(" ");
            }
            formattedTime.append(minutes).append(formatted_time_minutes);
            --timeParamsCount;
        }
        if (seconds > 0L && timeParamsCount > 0) {
            if (formattedTime.length() > 0) {
                formattedTime.append(" ");
            }
            formattedTime.append(seconds).append(formatted_time_seconds);
        }
        return formattedTime.toString();
    }

    public static String getFormattedTime(@NotNull Duration duration, int timeParamsCount) {
        return TimeFormatter.getFormattedTime(duration, timeParamsCount, formatted_time_days, formatted_time_hours, formatted_time_minutes, formatted_time_seconds);
    }

    public static String getFormattedTime(@NotNull Duration duration) {
        return TimeFormatter.getFormattedTime(duration, 2);
    }

    @Deprecated(forRemoval=true)
    public static long unix() {
        return System.currentTimeMillis() / 1000L;
    }

    @Deprecated(forRemoval=true)
    public static boolean isBefore(long millis) {
        return System.currentTimeMillis() < millis;
    }

    @Deprecated(forRemoval=true)
    public static boolean isAfter(long millis) {
        return System.currentTimeMillis() > millis;
    }

    static {
        MM_SS_TIME_FORMAT_UTC.setTimeZone(TimeZone.getTimeZone("UTC"));
        HH_MM_SS_TIME_FORMAT_UTC.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

