/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.arguments;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.api.Sender;

public class EnumArg
extends Argument {
    private final List<String> values = new ArrayList<String>();
    private final String name;

    public EnumArg(Enum[] values, String name) {
        this.name = name;
        this.values.addAll(Stream.of(values).map(Enum::name).collect(Collectors.toList()));
    }

    @Override
    public boolean valid(String s) {
        return this.values.contains(s);
    }

    public List<String> completions(Sender commandSender) {
        return this.values;
    }

    @Override
    public String argumentName() {
        return this.name;
    }
}

