/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.files;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class FileUtils {
    public static String readString(Path path) {
        try {
            return Files.readString(path, StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static void writeString(Path path, String text) {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                com.google.common.io.Files.createParentDirs((File)path.toFile());
            }
            Files.writeString(path, (CharSequence)text, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void downloadFileTo(String source, String destination) throws IOException {
        int length;
        URL url = new URL(source);
        InputStream is = url.openStream();
        Path destinationPath = Path.of(destination, new String[0]);
        if (!Files.exists(destinationPath, new LinkOption[0])) {
            com.google.common.io.Files.createParentDirs((File)destinationPath.toFile());
        }
        FileOutputStream os = new FileOutputStream(destinationPath.toFile());
        byte[] b = new byte[2048];
        while ((length = is.read(b)) != -1) {
            ((OutputStream)os).write(b, 0, length);
        }
        is.close();
        ((OutputStream)os).close();
    }
}

