/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.protocol;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedRegistrable;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.destroystokyo.paper.profile.PlayerProfile;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Rotatable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.Vector;
import tkachgeek.tkachutils.numbers.NumbersUtils;
import tkachgeek.tkachutils.player.PlayerUtils;
import tkachgeek.tkachutils.reflection.BukkitReflectionUtils;
import tkachgeek.tkachutils.server.ServerUtils;

public class Packet {
    public static void setSlot(Player player, int slot, ItemStack item) {
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.SET_SLOT);
        packet.getIntegers().write(0, (Object)BukkitReflectionUtils.getActiveWindowId(player));
        if (ServerUtils.isVersionGreater_1_16_5()) {
            packet.getIntegers().write(1, (Object)0);
            packet.getIntegers().write(2, (Object)slot);
        } else {
            packet.getIntegers().write(1, (Object)slot);
        }
        packet.getItemModifier().write(0, (Object)item);
        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
    }

    public static void updateSlot(Player player, int slot) {
        Packet.setSlot(player, slot, player.getInventory().getItem(slot));
    }

    public static void clearInventory(Player player) {
        PlayerInventory inventory = player.getInventory();
        ItemStack air = new ItemStack(Material.AIR);
        for (int slot = 0; slot < 36; ++slot) {
            ItemStack item = inventory.getItem(slot);
            if (item == null || !item.getType().isItem()) continue;
            Packet.setSlot(player, slot, air);
        }
    }

    public static void spawnLivingEntity(Player player, int id, int entityId, Location loc) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY_LIVING);
        packet.getIntegers().write(0, (Object)id);
        packet.getIntegers().write(1, (Object)entityId);
        packet.getIntegers().write(2, (Object)0);
        packet.getUUIDs().write(0, (Object)UUID.randomUUID());
        packet.getDoubles().write(0, (Object)loc.getX());
        packet.getDoubles().write(1, (Object)loc.getY());
        packet.getDoubles().write(2, (Object)loc.getZ());
        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
    }

    public static void destroyEntity(Player player, int id) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
        packet.getIntegerArrays().write(0, (Object)new int[]{id});
        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
    }

    public static void setEntityStatus(Player receiver, Entity entity, byte status) {
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_METADATA);
        packet.getIntegers().write(0, (Object)entity.getEntityId());
        WrappedDataWatcher watcher = new WrappedDataWatcher();
        WrappedDataWatcher.Serializer serializer = WrappedDataWatcher.Registry.get(Byte.class);
        watcher.setEntity(entity);
        watcher.setObject(0, serializer, (Object)64);
        packet.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
        ProtocolLibrary.getProtocolManager().sendServerPacket(receiver, packet);
    }

    public static void setEntityFrozen(Player receiver, Entity entity, int ticksFrozen) {
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_METADATA);
        packet.getIntegers().write(0, (Object)entity.getEntityId());
        WrappedDataWatcher watcher = new WrappedDataWatcher();
        WrappedDataWatcher.Serializer serializer = WrappedDataWatcher.Registry.get(Integer.class);
        watcher.setEntity(entity);
        watcher.setObject(7, serializer, (Object)ticksFrozen);
        packet.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
        ProtocolLibrary.getProtocolManager().sendServerPacket(receiver, packet);
    }

    public static void teleportEntity(Player receiver, int entityId, Location location) {
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        PacketContainer packet = manager.createPacket(PacketType.Play.Server.ENTITY_TELEPORT);
        packet.getIntegers().write(0, (Object)entityId);
        packet.getDoubles().write(0, (Object)location.getX()).write(1, (Object)location.getY()).write(2, (Object)location.getZ());
        manager.sendServerPacket(receiver, packet);
    }

    public static void moveEntity(Player receiver, int entityId, Vector vector) {
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        PacketContainer packet = manager.createPacket(PacketType.Play.Server.REL_ENTITY_MOVE);
        packet.getIntegers().write(0, (Object)entityId);
        packet.getShorts().write(0, (Object)((short)(vector.getX() * 4096.0))).write(1, (Object)((short)(vector.getY() * 4096.0))).write(2, (Object)((short)(vector.getZ() * 4096.0)));
        packet.getBooleans().write(0, (Object)false);
        packet.getBooleans().write(1, (Object)false);
        manager.sendServerPacket(receiver, packet);
    }

    public static void setHead(Player receiver, PlayerProfile playerProfile, Location location, BlockFace rotation) {
        receiver.sendBlockChange(location, Material.PLAYER_HEAD.createBlockData(blockData -> ((Rotatable)blockData).setRotation(rotation)));
        Packet.updateHead(receiver, playerProfile, location);
    }

    public static void updateHead(Player receiver, PlayerProfile playerProfile, Location location) {
        if (playerProfile == null) {
            return;
        }
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        PacketContainer packet = manager.createPacket(PacketType.Play.Server.TILE_ENTITY_DATA);
        packet.getBlockPositionModifier().write(0, (Object)new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
        if (ServerUtils.isVersionGreater("1.17.1")) {
            packet.getBlockEntityTypeModifier().write(0, (Object)WrappedRegistrable.blockEntityType((String)"skull"));
        } else {
            packet.getIntegers().write(0, (Object)4);
        }
        NbtCompound base = NbtFactory.ofCompound((String)"");
        base.put("x", location.getBlockX());
        base.put("y", location.getBlockY());
        base.put("z", location.getBlockZ());
        base.put("id", "minecraft:skull");
        NbtCompound nbt = NbtFactory.ofCompound((String)"SkullOwner");
        nbt.put("Id", NumbersUtils.convertToInts(playerProfile.getId()));
        nbt.put("Name", "");
        NbtCompound properties = NbtFactory.ofCompound((String)"Properties");
        NbtCompound skin = NbtFactory.ofCompound((String)"");
        skin.put("Value", PlayerUtils.getTextureValue(playerProfile));
        properties.put("textures", (NbtBase)NbtFactory.ofList((String)"textures", (Object[])new NbtCompound[]{skin}));
        nbt.put("Properties", (NbtBase)properties);
        base.put("SkullOwner", (NbtBase)nbt);
        packet.getNbtModifier().write(0, (Object)base);
        try {
            manager.sendServerPacket(receiver, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

