/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import tkachgeek.tkachutils.numbers.NumbersUtils;
import tkachgeek.tkachutils.text.StringIntEntry;

public class StringUtils {
    public static final Comparator<StringIntEntry> SUGGESTION_COMPARATOR = Comparator.comparingInt(StringIntEntry::getInt);
    private static final Pattern SAFE_STRING_PATTERN = Pattern.compile("^[\\w\u0430-\u044f\u0410-\u042f]+[\\w\u0430-\u044f\u0410-\u042f\\s]*$");

    public static int searchSimilarity(String string, String written) {
        if (string.equals(written)) {
            return Integer.MAX_VALUE;
        }
        if (string.startsWith(written)) {
            return Integer.MAX_VALUE;
        }
        if (string.contains(written)) {
            return written.length() * written.length();
        }
        int score = 0;
        int stringPointer = 0;
        int stringLength = string.length();
        int writtenPointer = 0;
        int writtenLength = written.length();
        char[] writtenArray = written.toCharArray();
        char[] stringArray = string.toCharArray();
        boolean applyMultiplier = true;
        while (writtenPointer < writtenLength && stringPointer < stringLength) {
            if (writtenArray[writtenPointer++] == stringArray[stringPointer]) {
                score += applyMultiplier ? 10 : 1;
                ++stringPointer;
                applyMultiplier = true;
                continue;
            }
            --score;
            applyMultiplier = false;
        }
        return score;
    }

    public static int searchSimilarity(String string, String written, boolean ignoreCase) {
        return ignoreCase ? StringUtils.searchSimilarity(string.toLowerCase(), written.toLowerCase()) : StringUtils.searchSimilarity(string, written);
    }

    public static List<String> getSuggestions(List<String> variants, String written) {
        return StringUtils.getSuggestions(variants, written, Integer.MAX_VALUE);
    }

    public static List<String> getSuggestions(List<String> variants, String written, int limit) {
        if (written.length() == 0) {
            return variants;
        }
        ArrayList<StringIntEntry> suggestions = new ArrayList<StringIntEntry>();
        for (String x : variants) {
            int similarity = StringUtils.searchSimilarity(x, written, true);
            if (similarity <= 0) continue;
            suggestions.add(new StringIntEntry(x, similarity));
        }
        suggestions.sort(SUGGESTION_COMPARATOR.reversed());
        ArrayList<String> limited = new ArrayList<String>(NumbersUtils.notGreater(limit, suggestions.size()));
        for (StringIntEntry suggestion : suggestions) {
            if (limit-- == 0) break;
            limited.add(suggestion.getString());
        }
        return limited;
    }

    public static List<String> splitEqually(String text, int size) {
        ArrayList<String> ret = new ArrayList<String>((text.length() + size - 1) / size);
        for (int start = 0; start < text.length(); start += size) {
            ret.add(text.substring(start, Math.min(text.length(), start + size)));
        }
        return ret;
    }

    public static boolean isSafetyString(String string) {
        return SAFE_STRING_PATTERN.matcher(string).find();
    }

    public static boolean containsIgnoreCase(String source, String toSearch) {
        return Objects.equals(source, toSearch) || source.toLowerCase().contains(toSearch.toLowerCase());
    }

    public static boolean startWithIgnoreCase(String original, String startWith) {
        return original.equals(startWith) || original.toLowerCase().startsWith(startWith.toLowerCase());
    }

    public static boolean endsWithIgnoreCase(String original, String endsWith) {
        return original.equals(endsWith) || original.toLowerCase().endsWith(endsWith.toLowerCase());
    }

    public static String[] safetySplit(String arguments, String regex) {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(arguments.split(regex)));
        if (arguments.endsWith(regex)) {
            args.add("");
        }
        return args.toArray(new String[0]);
    }
}

