/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.text.component;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import tkachgeek.tkachutils.colors.ColorUtils;

public class ComponentGradient {
    public static Component of(String text, TextColor ... colors) {
        if (colors.length == 0) {
            return Component.text(text);
        }
        if (colors.length == 1) {
            return Component.text(text).color(colors[0]);
        }
        Component component = Component.empty();
        if (colors.length == 2) {
            for (int i = 0; i < text.length(); ++i) {
                component = component.append(Component.text(text.charAt(i)).color(TextColor.lerp(((float)i + 1.0f) / (float)text.length(), colors[0], colors[1])));
            }
            return component;
        }
        float sectionLen = (float)text.length() / (0.0f + (float)colors.length - 1.0f);
        for (int i = 0; i < text.length(); ++i) {
            component = component.append(Component.text(text.charAt(i)).color(ColorUtils.lerpManyColors(i, sectionLen, colors)));
        }
        return component;
    }
}

