/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.arguments;

import java.util.Arrays;
import java.util.List;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.api.Sender;

public class ListArg
extends Argument {
    final List<String> acceptableStrings;
    private final String name;

    public ListArg(String name, List<String> acceptableStrings) {
        this.name = name;
        this.acceptableStrings = acceptableStrings;
    }

    public ListArg(String name, String ... acceptableStrings) {
        this.name = name;
        this.acceptableStrings = Arrays.asList(acceptableStrings);
    }

    @Override
    public boolean valid(String raw) {
        return this.acceptableStrings.contains(raw);
    }

    public List<String> completions(Sender sender) {
        return this.acceptableStrings;
    }

    @Override
    public String argumentName() {
        return this.name;
    }
}

