/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.comparators;

import java.util.Comparator;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import tkachgeek.tkachutils.block.BlockUtils;

public abstract class Comparators {

    public static class BlockByDistanceComparator
    implements Comparator<Block> {
        private final Location origin;

        public BlockByDistanceComparator(@Nonnull Location origin) {
            this.origin = origin;
        }

        public BlockByDistanceComparator(@Nonnull Block origin) {
            this.origin = BlockUtils.getCenter(origin);
        }

        @Override
        public int compare(Block o1, Block o2) {
            return Double.compare(BlockUtils.getCenter(o1).distanceSquared(this.origin), BlockUtils.getCenter(o2).distanceSquared(this.origin));
        }
    }

    public static class EntityByDistanceComparator
    implements Comparator<Entity> {
        private final Location origin;

        public EntityByDistanceComparator(@Nonnull Entity origin) {
            this.origin = origin.getLocation();
        }

        public EntityByDistanceComparator(@Nonnull Location origin) {
            this.origin = origin;
        }

        @Override
        public int compare(Entity o1, Entity o2) {
            return Double.compare(o1.getLocation().distanceSquared(this.origin), o2.getLocation().distanceSquared(this.origin));
        }
    }

    public static class LocationByDistanceComparator
    implements Comparator<Location> {
        private final Location origin;

        public LocationByDistanceComparator(Location origin) {
            this.origin = origin;
        }

        @Override
        public int compare(Location o1, Location o2) {
            return Double.compare(o1.distanceSquared(this.origin), o2.distanceSquared(this.origin));
        }
    }
}

