/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.dynamicBossBar.broadcast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import tkachgeek.tkachutils.dynamicBossBar.broadcast.BroadcastBossBarBuilder;
import tkachgeek.tkachutils.numbers.NumbersUtils;

public final class BroadcastBossBar {
    private final UUID uuid;
    private final Supplier<Component> title;
    private final Supplier<Float> progress;
    private final Supplier<Boolean> shouldRemove;
    private final Function<Player, Boolean> shouldDisplay;
    private final Supplier<BossBar.Color> color;
    private final Supplier<BossBar.Overlay> overlay;
    private final BossBar bossBar;
    private final Supplier<Collection<UUID>> viewers;
    private Collection<UUID> previousViewers = new ArrayList<UUID>();

    BroadcastBossBar(UUID uuid, Supplier<Component> title, Supplier<Float> progress, Supplier<Boolean> shouldRemove, Function<Player, Boolean> shouldDisplay, Supplier<BossBar.Color> color, Supplier<BossBar.Overlay> overlay, Supplier<Collection<UUID>> viewers) {
        this.uuid = uuid;
        this.title = title;
        this.progress = progress;
        this.shouldRemove = shouldRemove;
        this.shouldDisplay = shouldDisplay;
        this.color = color;
        this.overlay = overlay;
        this.viewers = viewers;
        this.bossBar = BossBar.bossBar(title.get(), progress.get().floatValue(), color.get(), overlay.get());
    }

    public static BroadcastBossBarBuilder of(Supplier<Component> title) {
        return new BroadcastBossBarBuilder().setTitle(title);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Supplier<Component> getTitle() {
        return this.title;
    }

    public Supplier<Float> getProgress() {
        return this.progress;
    }

    public Supplier<Boolean> getShouldRemove() {
        return this.shouldRemove;
    }

    public Function<Player, Boolean> getShouldDisplay() {
        return this.shouldDisplay;
    }

    public Supplier<BossBar.Color> getColor() {
        return this.color;
    }

    public Supplier<BossBar.Overlay> getOverlay() {
        return this.overlay;
    }

    public BossBar getBossBar() {
        return this.bossBar;
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BroadcastBossBar that = (BroadcastBossBar)o;
        return this.uuid.equals(that.uuid);
    }

    public void hide(Player player) {
        player.hideBossBar(this.bossBar);
    }

    public void hideAll() {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            onlinePlayer.hideBossBar(this.bossBar);
        }
    }

    public void update() {
        this.bossBar.name(this.title.get());
        this.bossBar.color(this.color.get());
        this.bossBar.overlay(this.overlay.get());
        this.bossBar.progress((float)NumbersUtils.bound(this.progress.get().floatValue(), 0.0, 1.0));
        Collection<UUID> newViewers = this.viewers.get();
        this.previousViewers.removeAll(newViewers);
        this.previousViewers.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).forEach(player -> player.hideBossBar(this.bossBar));
        newViewers.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).forEach(player -> {
            if (this.shouldDisplay.apply((Player)player).booleanValue()) {
                player.showBossBar(this.bossBar);
            } else {
                player.hideBossBar(this.bossBar);
            }
        });
        this.previousViewers = newViewers;
    }
}

