/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.dynamicBossBar.personal;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import tkachgeek.tkachutils.dynamicBossBar.personal.DynamicBossBarBuilder;
import tkachgeek.tkachutils.numbers.NumbersUtils;

public final class DynamicBossBar {
    private final UUID uuid;
    private final Supplier<Component> title;
    private final Supplier<Float> progress;
    private final Supplier<Boolean> shouldRemove;
    private final Supplier<Boolean> shouldDisplay;
    private final Supplier<BossBar.Color> color;
    private final Supplier<BossBar.Overlay> overlay;
    private final BossBar bossBar;

    DynamicBossBar(UUID uuid, Supplier<Component> title, Supplier<Float> progress, Supplier<Boolean> shouldRemove, Supplier<Boolean> shouldDisplay, Supplier<BossBar.Color> color, Supplier<BossBar.Overlay> overlay) {
        this.uuid = uuid;
        this.title = title;
        this.progress = progress;
        this.shouldRemove = shouldRemove;
        this.shouldDisplay = shouldDisplay;
        this.color = color;
        this.overlay = overlay;
        this.bossBar = BossBar.bossBar(title.get(), progress.get().floatValue(), color.get(), overlay.get());
    }

    public static DynamicBossBarBuilder of(Supplier<Component> title) {
        return new DynamicBossBarBuilder().setTitle(title);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Supplier<Component> getTitle() {
        return this.title;
    }

    public Supplier<Float> getProgress() {
        return this.progress;
    }

    public Supplier<Boolean> getShouldRemove() {
        return this.shouldRemove;
    }

    public Supplier<Boolean> getShouldDisplay() {
        return this.shouldDisplay;
    }

    public Supplier<BossBar.Color> getColor() {
        return this.color;
    }

    public Supplier<BossBar.Overlay> getOverlay() {
        return this.overlay;
    }

    public BossBar getBossBar() {
        return this.bossBar;
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicBossBar that = (DynamicBossBar)o;
        return this.uuid.equals(that.uuid);
    }

    public void hide(Player player) {
        player.hideBossBar(this.bossBar);
    }

    public void hideAll() {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            onlinePlayer.hideBossBar(this.bossBar);
        }
    }

    public void update(Player onlinePlayer) {
        this.bossBar.name(this.title.get());
        this.bossBar.color(this.color.get());
        this.bossBar.overlay(this.overlay.get());
        this.bossBar.progress((float)NumbersUtils.bound(this.progress.get().floatValue(), 0.0, 1.0));
        if (this.shouldDisplay.get().booleanValue()) {
            onlinePlayer.showBossBar(this.bossBar);
        } else {
            onlinePlayer.hideBossBar(this.bossBar);
        }
    }
}

