/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands;

import java.util.Collection;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import org.jetbrains.annotations.NotNull;
import ru.cwcode.commands.Command;
import ru.cwcode.commands.api.CommandsAPI;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.commands.arguments.ExactStringArg;
import ru.cwcode.commands.color.ColorGenerationStrategy;
import tkachgeek.tkachutils.messages.Message;
import tkachgeek.tkachutils.messages.MessageReturn;

public abstract class Argument {
    protected String raw;
    private String tag = "";
    private boolean optional;

    protected Argument(String raw) {
        this.raw = raw;
    }

    public Argument() {
    }

    @NotNull
    public TextComponent toComponent(ColorGenerationStrategy color, boolean canPerformedBy) {
        if (this.isOptional()) {
            return Component.text("[" + this.argumentName() + "]", color.optional(canPerformedBy));
        }
        if (this instanceof ExactStringArg) {
            return Component.text(this.argumentName(), color.subcommand(canPerformedBy));
        }
        TextComponent component = Component.text("<" + this.argumentName() + ">", color.argument(canPerformedBy));
        if (this.hint().isEmpty()) {
            return component;
        }
        return (TextComponent)component.hoverEvent(HoverEvent.showText(Component.text(this.hint(), color.accent(canPerformedBy))));
    }

    public String toReadableString() {
        if (this.isOptional()) {
            return "[" + this.argumentName() + "]";
        }
        if (this instanceof ExactStringArg) {
            return this.argumentName();
        }
        String args = "<" + this.argumentName() + ">";
        if (this.hint().isEmpty()) {
            return args;
        }
        return args;
    }

    public abstract boolean valid(String var1);

    public boolean valid(Sender sender, String raw, List<String> arguments) {
        return this.valid(raw);
    }

    public abstract Collection<String> completions(Sender var1);

    public Collection<String> completions(Sender sender, List<String> written) {
        return this.completions(sender);
    }

    public Argument optional() {
        this.optional = true;
        return this;
    }

    public Argument optional(String defaultValue) {
        this.optional = true;
        this.raw = defaultValue;
        return this;
    }

    public abstract String argumentName();

    public boolean notNull() {
        return this.raw != null;
    }

    public Integer toInt() {
        try {
            if (this.notNull()) {
                return Integer.parseInt(this.raw);
            }
        }
        catch (Exception exception) {
            CommandsAPI.getPlatform().getLogger().warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c `" + this.raw + "` \u0432 int \u0432 " + this.argumentName());
        }
        return null;
    }

    public Float toFloat() {
        try {
            if (this.notNull()) {
                return Float.valueOf(Float.parseFloat(this.raw));
            }
        }
        catch (Exception exception) {
            CommandsAPI.getPlatform().getLogger().warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c `" + this.raw + "` \u0432 float \u0432 " + this.argumentName());
        }
        return null;
    }

    public String toString() {
        if (this.notNull()) {
            return this.raw;
        }
        CommandsAPI.getPlatform().getLogger().warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c `" + (this.raw != null ? this.raw : "~null~") + "` \u0432 \u0441\u0442\u0440\u043e\u043a\u0443 \u0432 " + this.argumentName());
        return null;
    }

    public Double toDouble() {
        try {
            if (this.notNull()) {
                return Double.parseDouble(this.raw);
            }
        }
        catch (Exception exception) {
            CommandsAPI.getPlatform().getLogger().warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c `" + this.raw + "` \u0432 double \u0432 " + this.argumentName());
        }
        return null;
    }

    public Boolean toBoolean() {
        try {
            if (this.notNull()) {
                return Boolean.parseBoolean(this.raw);
            }
        }
        catch (Exception exception) {
            CommandsAPI.getPlatform().getLogger().warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c `" + this.raw + "` \u0432 boolean \u0432 " + this.argumentName());
        }
        return null;
    }

    public boolean isOptional() {
        return this.optional;
    }

    protected String hint() {
        return "";
    }

    public Argument newInstance() throws MessageReturn {
        try {
            return (Argument)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ignored) {
            throw new MessageReturn(Message.from("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430 " + this.argumentName()));
        }
    }

    public Argument tag(String tag) {
        this.tag = tag;
        return this;
    }

    public String getTag() {
        return this.tag.isEmpty() ? this.argumentName() : this.tag;
    }

    public Component invalidMessage(Command command, Sender sender, String written) {
        ColorGenerationStrategy colorScheme = command.getColorScheme();
        return ((TextComponent)Component.text(written, colorScheme.accent(true)).append(Component.text(" \u043d\u0435\u043b\u044c\u0437\u044f \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043a\u0430\u043a ", colorScheme.main()))).append(Component.text(this.argumentName(), colorScheme.accent(true)));
    }
}

