/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import org.jetbrains.annotations.NotNull;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.ArgumentFitnessResult;
import ru.cwcode.commands.Command;
import ru.cwcode.commands.Permissible;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.commands.arguments.ComplexArg;
import ru.cwcode.commands.arguments.ExactStringArg;
import ru.cwcode.commands.arguments.spaced.SpacedArgument;
import ru.cwcode.commands.color.ColorGenerationStrategy;
import ru.cwcode.commands.executor.AbstractExecutor;
import ru.cwcode.commands.preconditions.OnlyForNonPlayersPrecondition;
import ru.cwcode.commands.preconditions.OnlyForPlayersPrecondition;
import ru.cwcode.commands.preconditions.Precondition;
import ru.cwcode.commands.preconditions.PredicatePrecondition;
import ru.cwcode.commands.preconditions.processor.PermissionPrecondition;
import ru.cwcode.commands.preconditions.processor.PreconditionProcessor;
import ru.cwcode.commands.preconditions.processor.PreconditionRequirements;
import ru.cwcode.commands.preconditions.processor.PreconditionResult;
import tkachgeek.tkachutils.text.StringUtils;

public class ArgumentSet
implements Permissible {
    protected final Argument[] arguments;
    protected final AbstractExecutor executor;
    Deque<Precondition> preconditions = new ArrayDeque<Precondition>();
    String permission;
    boolean spacedLastArgument = false;
    int optionalStart;
    Component help;
    private String confirmableString = "";
    private long timeToConfirm = 0L;
    private boolean hidden = false;

    public ArgumentSet(AbstractExecutor executor, ExactStringArg exactStringArg, Argument ... arguments) {
        this(executor, exactStringArg.getExactString(), ArgumentSet.collectArgs(exactStringArg, arguments));
    }

    public ArgumentSet(AbstractExecutor executor, String permission, Argument ... arguments) {
        this.arguments = this.unboxComplexArgs(arguments);
        this.executor = executor;
        this.permission = permission;
        int pos = 0;
        int len = arguments.length - 1;
        int optionalStart = -1;
        for (Argument argument : arguments) {
            if (argument instanceof SpacedArgument) {
                if (pos != len) {
                    Logger.getGlobal().warning("\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442 " + argument.getClass().getName() + " \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u043c \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u0432");
                } else {
                    this.spacedLastArgument = true;
                }
            }
            if (argument.isOptional()) {
                if (optionalStart == -1) {
                    optionalStart = pos;
                }
            } else if (optionalStart != -1) {
                Logger.getGlobal().warning("\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442 " + argument.getClass().getName() + " \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0435 \u043e\u043f\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u043c, \u043f\u043e\u0441\u043a\u043e\u043b\u044c\u043a\u0443 \u043f\u0435\u0440\u0435\u0434 \u043d\u0438\u043c \u0443\u0436\u0435 \u0431\u044b\u043b \u043e\u043f\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0439");
                optionalStart = -10;
            }
            ++pos;
        }
        this.optionalStart = optionalStart;
    }

    @NotNull
    private static Argument[] collectArgs(ExactStringArg exactStringArg, Argument[] arguments) {
        Argument[] args = new Argument[arguments.length + 1];
        args[0] = exactStringArg;
        System.arraycopy(arguments, 0, args, 1, arguments.length);
        return args;
    }

    void updatePermissionPrecondition() {
        for (Precondition precondition : this.preconditions) {
            if (!(precondition instanceof PermissionPrecondition)) continue;
            return;
        }
        this.preconditions.addFirst(new PermissionPrecondition(this));
    }

    private Argument[] unboxComplexArgs(Argument[] arguments) {
        ArrayList<Argument> args = new ArrayList<Argument>();
        for (Argument argument : arguments) {
            if (argument instanceof ComplexArg) {
                ComplexArg ca = (ComplexArg)argument;
                args.addAll(ca.getArgs());
                continue;
            }
            args.add(argument);
        }
        return args.toArray(new Argument[0]);
    }

    public ArgumentSet(AbstractExecutor executor, Argument ... arguments) {
        this(executor, "", arguments);
    }

    public ArgumentSet(ArgumentSet toClone, Argument ... newArgs) {
        this.arguments = newArgs;
        this.executor = toClone.executor;
        this.preconditions = toClone.preconditions;
        this.permission = toClone.permission;
        this.spacedLastArgument = toClone.spacedLastArgument;
        this.optionalStart = toClone.optionalStart;
        this.help = toClone.help;
        this.confirmableString = toClone.confirmableString;
        this.timeToConfirm = toClone.timeToConfirm;
    }

    public ArgumentSet canExecute(Predicate<Sender> canExecute) {
        this.preconditions.add(new PredicatePrecondition(canExecute));
        return this;
    }

    public ArgumentSet preconditions(Precondition ... preconditions) {
        this.preconditions.addAll(Arrays.asList(preconditions));
        return this;
    }

    public ArgumentSet blockForPlayers() {
        this.preconditions.add(OnlyForNonPlayersPrecondition.getInstance());
        return this;
    }

    public ArgumentSet blockForNonPlayers() {
        this.preconditions.add(OnlyForPlayersPrecondition.getInstance());
        return this;
    }

    public ArgumentSet help(Component help) {
        this.help = help;
        return this;
    }

    public ArgumentSet help(String help) {
        this.help = Component.text(help);
        return this;
    }

    public ArgumentSet confirmWith(String confirmableString, long timeToConfirm) {
        this.confirmableString = confirmableString;
        this.timeToConfirm = timeToConfirm;
        return this;
    }

    public boolean hasHelp() {
        return this.help != null;
    }

    public Component toComponent(Sender sender, ColorGenerationStrategy color) {
        PreconditionResult preconditions = this.checkPreconditions(sender);
        TextComponent argumentsAccumulator = Component.empty();
        for (Argument arg : this.arguments) {
            argumentsAccumulator = (TextComponent)((TextComponent)argumentsAccumulator.append(Component.space())).append(arg.toComponent(color, preconditions.canPerform()));
        }
        return ((TextComponent)argumentsAccumulator.append(Component.text(this.spacedLastArgument ? "..." : ""))).append(sender.isOp() ? Component.text(" " + this.permission, color.permissions(preconditions.canPerform())) : Component.empty());
    }

    protected boolean canPerformedBy(Sender sender) {
        return this.checkPreconditions(sender).canPerform();
    }

    protected PreconditionResult checkPreconditions(Sender sender) {
        return PreconditionProcessor.process(sender, this.preconditions);
    }

    protected boolean checkPreconditions(Sender sender, PreconditionRequirements requirements) {
        return PreconditionProcessor.process(sender, this.preconditions).isSatisfy(requirements);
    }

    public void execute(Sender sender, String[] args, Command command) {
        if (this.timeToConfirm != 0L) {
            sender.sendMessage(((TextComponent)((TextComponent)Component.text("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 ", command.getColorScheme().main()).append(Component.text(this.confirmableString, command.getColorScheme().accent(true)))).append(Component.text(" \u0434\u043b\u044f \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f", command.getColorScheme().main()))).clickEvent(ClickEvent.runCommand(this.confirmableString)));
            sender.confirm(this.confirmableString, this.timeToConfirm, () -> this.executor.prepare(sender, args, this, command), () -> sender.sendMessage(Component.text("\u0412\u0440\u0435\u043c\u044f \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u0432\u044b\u0448\u043b\u043e", command.getColorScheme().main())));
        } else {
            this.executor.prepare(sender, args, this, command);
        }
    }

    public String toString() {
        return this.executor.getClass().getSimpleName() + ": " + this.getArgumentsString() + (this.spacedLastArgument ? "..." : "");
    }

    private String getArgumentsString() {
        if (this.arguments.length == 0) {
            return "[]";
        }
        StringBuilder result = new StringBuilder();
        for (Argument arg : this.arguments) {
            result.append(arg.toReadableString()).append(", ");
        }
        result.delete(result.length() - 2, result.length());
        return "[" + result + "]";
    }

    public boolean shouldShowInHelp(List<String> args) {
        return !this.isEmpty() && (args.isEmpty() || args.get(0).isEmpty() || !this.firstArgIsExactStringArg() || StringUtils.startWithIgnoreCase(((ExactStringArg)this.arguments[0]).getExactString(), args.get(0)));
    }

    private boolean isEmpty() {
        return this.arguments.length == 0;
    }

    private boolean firstArgIsExactStringArg() {
        return this.arguments.length > 0 && this.arguments[0] instanceof ExactStringArg;
    }

    public ArgumentSet hidden() {
        this.hidden = true;
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    protected ArgumentFitnessResult isArgumentsFit(Sender sender, String ... args) {
        if (args.length != this.arguments.length && !this.spacedLastArgument) {
            return ArgumentFitnessResult.NOT_FIT;
        }
        if (args.length < this.arguments.length) {
            return ArgumentFitnessResult.NOT_FIT;
        }
        if (this.spacedLastArgument) {
            String[] copy = Arrays.copyOfRange(args, 0, this.arguments.length);
            copy[this.arguments.length - 1] = String.join((CharSequence)" ", Arrays.copyOfRange(args, this.arguments.length - 1, args.length));
            args = copy;
        }
        List<String> argList = List.of(args);
        for (int i = 0; i < args.length; ++i) {
            if (this.arguments[i].valid(sender, args[i], argList)) continue;
            return new ArgumentFitnessResult(this, this.arguments[i], args[i]);
        }
        return ArgumentFitnessResult.SUCCESS;
    }

    protected List<String> getCompletesFor(List<String> written, Sender sender) {
        int skipBecauseSpaced = 0;
        if (this.arguments.length == 0) {
            return Collections.emptyList();
        }
        if (this.spacedLastArgument && this.arguments.length < written.size()) {
            skipBecauseSpaced = written.size() - this.arguments.length;
            String writtenLastSpacedString = String.join((CharSequence)" ", written.subList(this.arguments.length - 1, written.size()));
            written = written.subList(0, this.arguments.length);
            written.set(this.arguments.length - 1, writtenLastSpacedString);
        }
        if (this.arguments.length >= written.size()) {
            for (int i = 0; i < written.size() - 1; ++i) {
                if (this.arguments[i].valid(sender, written.get(i), written)) continue;
                return Collections.emptyList();
            }
            ArrayList<String> completionOfLastArg = new ArrayList<String>();
            for (String completionLine : this.arguments[written.size() - 1].completions(sender, written)) {
                if (skipBecauseSpaced > 0) {
                    List<String> parts = List.of(completionLine.split(" "));
                    if (skipBecauseSpaced >= parts.size()) continue;
                    completionOfLastArg.add(String.join((CharSequence)" ", parts.subList(skipBecauseSpaced, parts.size())));
                    continue;
                }
                completionOfLastArg.add(completionLine);
            }
            return completionOfLastArg;
        }
        return Collections.emptyList();
    }

    @Override
    public String getPermission() {
        return this.permission;
    }
}

