/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.benchmark;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import tkachgeek.tkachutils.benchmark.BenchmarkIteration;
import tkachgeek.tkachutils.benchmark.BenchmarkResult;

public class BenchmarkChannel {
    List<BenchmarkIteration> iterations = new ArrayList<BenchmarkIteration>();

    public void print(String channel) {
        Logger log = Logger.getLogger(channel);
        HashMap<String, BenchmarkResult.StageResult> result = BenchmarkResult.calculate(this.iterations);
        int stagesMaxNameLen = Math.max(8, result.keySet().stream().max(Comparator.comparingInt(String::length)).get().length());
        AtomicLong max = new AtomicLong(-1L);
        AtomicLong min = new AtomicLong(-1L);
        AtomicLong avg = new AtomicLong(-1L);
        log.warning("\u0411\u0435\u043d\u0447\u043c\u0430\u0440\u043a \u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d");
        log.warning(String.format("\u0418\u0442\u0435\u0440\u0430\u0446\u0438\u0439 \u0432\u0441\u0435\u0433\u043e: %s", this.iterations.size()));
        log.warning(String.format("%" + stagesMaxNameLen + "s: %10s %12s %12s %s", "\u0421\u0442\u0430\u0434\u0438\u044f", "\u041c\u0438\u043d\u0438\u043c\u0443\u043c", "\u0421\u0440\u0435\u0434\u043d\u0435\u0435", "\u041c\u0430\u043a\u0441\u0438\u043c\u0443\u043c", "\u0417\u0430\u043f\u0443\u0441\u043a\u043e\u0432"));
        result.forEach((stage, value) -> {
            max.addAndGet(value.getMax());
            min.addAndGet(value.getMin());
            avg.addAndGet((long)value.getAvg());
            log.warning(String.format("%" + stagesMaxNameLen + "s: %10d %12d %12d %8d", stage, value.getMin(), (long)value.getAvg(), value.getMax(), value.getStarts()));
        });
        log.warning(String.format("%" + stagesMaxNameLen + "s: %10d %12d %12d", "\u0418\u0422\u041e\u0413\u041e:", min.get(), avg.get(), max.get()));
    }

    public void newIteration(long time) {
        this.lastIteration().stopLastStage(time);
        this.addIteration();
    }

    private void addIteration() {
        this.iterations.add(new BenchmarkIteration());
    }

    private BenchmarkIteration lastIteration() {
        if (this.iterations.size() == 0) {
            this.addIteration();
        }
        return this.iterations.get(this.iterations.size() - 1);
    }

    public void newStage(String stage, long time) {
        this.lastIteration().newStage(stage, time);
    }

    public void stopLastStage(long time) {
        this.lastIteration().stopLastStage(time);
    }
}

