/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.collections;

import java.util.Collections;
import java.util.List;

public class PagedCollectionWrapper<T> {
    List<T> entries;
    int pageSize;

    public PagedCollectionWrapper(List<T> entries, int pageSize) {
        this.entries = entries;
        this.pageSize = pageSize;
    }

    public List<T> getPage(int page) {
        int from = this.pageSize * (page - 1);
        int to = this.pageSize * page;
        if (from < 0 || to < 0) {
            return Collections.emptyList();
        }
        return this.entries.subList(Math.min(from, this.entries.size()), Math.min(to, this.entries.size()));
    }

    public int getPagesAmount() {
        return this.entries.isEmpty() ? 0 : this.entries.size() / this.pageSize + 1;
    }

    public int getPageSize() {
        return this.pageSize;
    }
}

