/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.confirmable.velocity;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.scheduler.ScheduledTask;
import java.time.Duration;
import tkachgeek.tkachutils.confirmable.velocity.ConfirmAPI;

public class ConfirmRequest {
    Player sender;
    String required;
    long timeToExpire;
    ScheduledTask expiredTask = null;
    Runnable onSuccess = null;
    Runnable onExpired = null;

    public ConfirmRequest(Player sender, String required, long millisToExpire) {
        this.sender = sender;
        this.required = required;
        this.timeToExpire = millisToExpire;
    }

    public void startTimer(ProxyServer server, Object plugin) {
        this.expiredTask = server.getScheduler().buildTask(plugin, () -> {
            if (this.onExpired != null) {
                this.onExpired.run();
            }
            ConfirmAPI.requests.remove(this.sender, this);
        }).delay(Duration.ofMillis(this.timeToExpire)).schedule();
    }

    public void stopTimer() {
        this.expiredTask.cancel();
    }
}

