/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.items.activeItem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import tkachgeek.tkachutils.items.activeItem.ActiveItem;
import tkachgeek.tkachutils.items.activeItem.ActiveItemListener;
import tkachgeek.tkachutils.items.activeItem.ItemAction;
import tkachgeek.tkachutils.items.activeItem.ItemActionEvent;

public class ActiveItemRegistry {
    static HashMap<JavaPlugin, PluginEntry> activeItems = new HashMap();

    public static void register(ActiveItem activeItem) {
        if (!activeItems.containsKey(activeItem.getPlugin())) {
            activeItems.put(activeItem.getPlugin(), new PluginEntry(activeItem.getPlugin()));
        }
        activeItems.get(activeItem.getPlugin()).addItem(activeItem);
    }

    public static void unregister(JavaPlugin plugin) {
        activeItems.remove(plugin);
    }

    public static void perform(JavaPlugin plugin, ItemActionEvent event) {
        if (activeItems.containsKey(plugin)) {
            activeItems.get(plugin).handleAction(event);
        }
    }

    private static class PluginEntry {
        List<ActiveItem> items = new ArrayList<ActiveItem>();
        ActiveItemListener listener;

        public PluginEntry(JavaPlugin plugin) {
            this.listener = new ActiveItemListener(plugin);
            Bukkit.getPluginManager().registerEvents((Listener)this.listener, (Plugin)plugin);
        }

        public void unregister() {
            this.items.clear();
            this.listener = null;
        }

        public void addItem(ActiveItem item) {
            this.items.add(item);
        }

        public boolean handlesAction(ItemAction action) {
            for (ActiveItem x : this.items) {
                if (!x.isBinded(action)) continue;
                return true;
            }
            return false;
        }

        public void handleAction(ItemActionEvent event) {
            for (ActiveItem x : this.items) {
                x.perform(event);
            }
        }
    }
}

