/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.location;

public enum YawDirection {
    NORTH,
    NORTH_EAST(0, 2),
    EAST,
    SOUTH_EAST(2, 4),
    SOUTH,
    SOUTH_WEST(4, 6),
    WEST,
    NORTH_WEST(6, 0);

    public static final float SEGMENT_SIZE = 22.5f;
    final float from;
    final float to;
    int[] primary = new int[2];
    float middle;
    private boolean isPrimary = true;

    private YawDirection(int prima1, int prima2) {
        this();
        this.isPrimary = false;
        this.primary[0] = prima1;
        this.primary[1] = prima2;
    }

    private YawDirection() {
        this.from = YawDirection.normalize(-22.5f + (float)(this.ordinal() * 2) * 22.5f);
        this.to = YawDirection.normalize(this.from + 45.0f);
        this.middle = this.from + 22.5f;
    }

    public static float normalize(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw = 360.0f + yaw;
        }
        return yaw;
    }

    public static YawDirection parseToPrimaries(float yaw) {
        YawDirection direction = YawDirection.parse(yaw);
        if (direction.isPrimary) {
            return direction;
        }
        YawDirection best = null;
        float bestDif = -1.0f;
        for (int i : direction.primary) {
            float dif = Math.abs(YawDirection.values()[i].middle - yaw);
            if (bestDif != -1.0f && !(dif < bestDif)) continue;
            bestDif = dif;
            best = YawDirection.values()[i];
        }
        return best;
    }

    public static YawDirection parse(float yaw) {
        yaw = YawDirection.normalize(yaw);
        for (YawDirection direction : YawDirection.values()) {
            if (!(Math.abs(direction.middle - yaw) <= 22.5f) && (direction.middle != 360.0f || !(yaw <= 22.5f))) continue;
            return direction;
        }
        return null;
    }
}

