/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.messages;

import java.util.Collection;
import java.util.Map;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import tkachgeek.tkachutils.messages.Placeholder;

public abstract class Message {
    private TextComponent message;

    public Message(TextComponent message) {
        this.message = message;
    }

    public Message(String message) {
        this(Message.from(message));
    }

    public Message placeholder(String placeholder, Component value) {
        return Placeholder.getInstance(this).replacePlaceholders(placeholder, value);
    }

    public Message placeholder(String placeholder, String value) {
        return this.placeholder(placeholder, Message.from(value));
    }

    public Message placeholder(String placeholder, Object value) {
        if (value instanceof Component) {
            return this.placeholder(placeholder, (Component)value);
        }
        return this.placeholder(placeholder, String.valueOf(value));
    }

    public Message placeholders(Map<String, String> placeholders) {
        Message message = this.clone();
        for (String placeholder : placeholders.keySet()) {
            message = message.placeholder(placeholder, placeholders.get(placeholder));
        }
        return message;
    }

    public TextComponent get() {
        return (TextComponent)this.message.decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE);
    }

    public void set(TextComponent message) {
        this.message = message;
    }

    public abstract void send(Audience var1);

    public abstract void send(String var1, Collection<? extends Audience> var2);

    public void broadcast(Collection<? extends Audience> receivers) {
        for (Audience audience : receivers) {
            this.send(audience);
        }
    }

    public abstract void sendActionBar(Audience var1);

    public abstract void sendActionBar(String var1, Collection<? extends Audience> var2);

    public void broadcastActionBar(Collection<? extends Audience> receivers) {
        for (Audience audience : receivers) {
            this.sendActionBar(audience);
        }
    }

    protected abstract Message clone();

    public String toString() {
        return Message.from(this.message);
    }

    public static TextComponent from(String message) {
        return LegacyComponentSerializer.legacySection().deserialize(message);
    }

    public static String from(Component message) {
        return LegacyComponentSerializer.legacySection().serialize(message);
    }
}

