/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.messages;

import com.velocitypowered.api.proxy.Player;
import java.util.Collection;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import tkachgeek.tkachutils.messages.Message;

public class VelocityMessage
extends Message {
    private static VelocityMessage instance;

    public static VelocityMessage getInstance(TextComponent message) {
        if (instance == null) {
            instance = new VelocityMessage(message);
        }
        instance.set(message);
        return instance;
    }

    public static VelocityMessage getInstance(String message) {
        return VelocityMessage.getInstance(Message.from(message));
    }

    public static VelocityMessage getInstance(Component component) {
        if (component instanceof TextComponent) {
            return VelocityMessage.getInstance((TextComponent)component);
        }
        return VelocityMessage.getInstance(Message.from(component));
    }

    private VelocityMessage() {
        this("empty");
    }

    public VelocityMessage(String message) {
        super(message);
    }

    public VelocityMessage(TextComponent message) {
        super(message);
    }

    @Override
    public void send(Audience player) {
        player.sendMessage(this::get);
    }

    @Override
    public void send(String name, Collection<? extends Audience> receivers) {
        for (Audience audience : receivers) {
            Player player;
            if (!(audience instanceof Player) || !(player = (Player)audience).getUsername().equals(name)) continue;
            this.send((Audience)player);
            return;
        }
    }

    @Override
    public void sendActionBar(Audience player) {
        player.sendActionBar(this::get);
    }

    @Override
    public void sendActionBar(String name, Collection<? extends Audience> audiences) {
        for (Audience audience : audiences) {
            Player player;
            if (!(audience instanceof Player) || !(player = (Player)audiences).getUsername().equals(name)) continue;
            this.sendActionBar((Audience)player);
            return;
        }
    }

    @Override
    protected Message clone() {
        return new VelocityMessage(this.get());
    }
}

