/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.numbers;

import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class NumbersUtils {
    public static final String[] suffix = new String[]{"", "k", "m", "b", "t"};

    public static double evalToHalf(double value) {
        return (double)((int)value) + (value - (double)((int)value) >= 0.5 ? 0.5 : 0.0);
    }

    public static int toPercent(double value) {
        return (int)(value * 100.0);
    }

    public static double toPercent(double value, int digits) {
        return NumbersUtils.round(value * 100.0, digits);
    }

    public static double round(double value, int digits) {
        double scale = Math.pow(10.0, digits);
        return Math.ceil(value * scale) / scale;
    }

    public static boolean isNumber(String str) {
        return str.matches("^-?\\d+(?:\\.\\d+)?$");
    }

    public static boolean isInteger(String str) {
        if (str == null) {
            return false;
        }
        char[] data = str.toCharArray();
        if (data.length == 0) {
            return false;
        }
        int index = 0;
        if (data[0] == '-' && data.length > 1) {
            index = 1;
        }
        while (index < data.length) {
            if (data[index] < '0' || data[index] > '9') {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static int bound(int value, int min, int max) {
        return Math.max(Math.min(value, max), min);
    }

    public static int notGreater(int value, int max) {
        return Math.min(value, max);
    }

    public static int notLower(int value, int min) {
        return Math.max(value, min);
    }

    public static double bound(double value, double min, double max) {
        return Math.max(Math.min(value, max), min);
    }

    public static double notGreater(double value, double max) {
        return Math.min(value, max);
    }

    public static double notLower(double value, double min) {
        return Math.max(value, min);
    }

    public static String shortNumberFormat(double number) {
        int index = 0;
        while (number >= 1000.0) {
            number /= 1000.0;
            ++index;
        }
        String formatted = String.format("%.1f", number).replace(',', '.');
        if (formatted.endsWith(".0")) {
            formatted = formatted.substring(0, formatted.length() - 2);
        }
        if (suffix.length <= index) {
            return formatted + "?";
        }
        return formatted + suffix[index];
    }

    public static double absolute(double min, double max, double current) {
        return (current - min) / (max - min);
    }

    public static double absolute(double max, double current) {
        return current / max;
    }

    public static String format(int value) {
        String formatted = String.valueOf(value);
        int length = formatted.length();
        int count = (length - 1) / 3 + 1;
        CharSequence[] parts = new String[count];
        int begin = 0;
        int end = length % 3;
        end = end == 0 ? 3 : end;
        for (int k = 0; k < count; ++k) {
            parts[k] = formatted.substring(begin, end);
            begin = end;
            end += 3;
        }
        return String.join((CharSequence)" ", parts);
    }

    public static int[] convertToInts(@Nullable UUID uuid) {
        if (uuid == null) {
            return NumbersUtils.convertToInts(UUID.randomUUID());
        }
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        int msb1 = (int)(msb >> 32);
        int msb2 = (int)msb;
        int lsb1 = (int)(lsb >> 32);
        int lsb2 = (int)lsb;
        return new int[]{msb1, msb2, lsb1, lsb2};
    }
}

