/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands;

import java.util.Arrays;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.ArgumentSet;

public class ArgumentParser {
    public final Argument[] args;

    public ArgumentParser(String[] raw, ArgumentSet set) {
        this.args = set.arguments;
        if (set.spacedLastArgument) {
            String[] copy = Arrays.copyOfRange(raw, 0, this.args.length);
            copy[this.args.length - 1] = String.join((CharSequence)" ", Arrays.copyOfRange(raw, this.args.length - 1, raw.length));
            raw = copy;
        }
        for (int i = 0; i < raw.length; ++i) {
            this.args[i].raw = raw[i];
        }
    }

    public Argument get(int index) {
        if (this.isPresent(index)) {
            return this.args[index];
        }
        return null;
    }

    public Argument get(String tag) {
        for (Argument arg : this.args) {
            if (!arg.getTag().equals(tag)) continue;
            return arg;
        }
        return null;
    }

    public boolean isPresent(int index) {
        return index >= 0 && index < this.args.length;
    }
}

