/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.arguments.basic;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.CompletionStyle;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.cwutils.numbers.NumbersUtils;

public class DoubleArg
extends Argument {
    double min = -1.7976931348623157E308;
    double max = Double.MAX_VALUE;
    CompletionStyle style = CompletionStyle.PLACEHOLDER;
    double step = 1.0;
    String placeholder = "\u0434\u0440\u043e\u0431\u043d\u043e\u0435 \u0447\u0438\u0441\u043b\u043e";

    public DoubleArg(String placeholder) {
        this.placeholder = placeholder;
    }

    public DoubleArg() {
    }

    public DoubleArg setMin(double min) {
        this.min = min;
        return this;
    }

    public DoubleArg setMax(double max) {
        this.max = max;
        return this;
    }

    public DoubleArg setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    public DoubleArg setStyle(CompletionStyle style) {
        this.style = style;
        return this;
    }

    public DoubleArg setStep(double step) {
        this.step = step;
        return this;
    }

    @Override
    public boolean valid(String raw) {
        try {
            if (!NumbersUtils.isNumber((String)raw)) {
                return false;
            }
            double parsed = Double.parseDouble(raw);
            return parsed >= this.min && parsed < this.max;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public List<String> completions(Sender sender) {
        switch (this.style) {
            case PLACEHOLDER: {
                return Collections.singletonList(this.placeholder);
            }
            case DIAPASON: {
                return Collections.singletonList(this.min + " -> " + this.max);
            }
            case LIST: {
                return DoubleStream.iterate(this.min, d -> d <= this.max, d -> d + this.step).limit(1000L).mapToObj(Double::toString).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    @Override
    public String argumentName() {
        return this.placeholder;
    }

    @Override
    public Object map() {
        return this.toDouble();
    }

    @Override
    protected String hint() {
        boolean minFlag;
        StringBuilder builder = new StringBuilder();
        boolean bl = minFlag = this.min != Double.MIN_VALUE;
        if (minFlag) {
            builder.append("\u041e\u0442 ").append(this.min);
        }
        if (this.max != Double.MAX_VALUE) {
            builder.append(minFlag ? " \u0434\u043e " : "\u0414\u043e ").append(this.max);
        }
        return builder.toString();
    }
}

