/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.preconditions;

import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.commands.preconditions.Precondition;

public class PredicatePrecondition
extends Precondition {
    @NotNull
    Predicate<Sender> predicate;
    @Nullable
    String cannotExecuteFeedback = null;

    public PredicatePrecondition(@NotNull Predicate<Sender> predicate, @Nullable String cannotExecuteFeedback) {
        this.predicate = predicate;
        this.cannotExecuteFeedback = cannotExecuteFeedback;
    }

    public PredicatePrecondition(@NotNull Predicate<Sender> predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean canExecute(Sender sender) {
        return this.predicate.test(sender);
    }

    @Override
    public boolean canSee(Sender sender) {
        return this.cannotExecuteFeedback != null || this.canExecute(sender);
    }

    @Override
    public String cannotExecuteFeedback(Sender sender) {
        return this.cannotExecuteFeedback;
    }
}

