/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.permissions;

import ru.cwcode.commands.permissions.PermissionGenerationStrategy;
import ru.cwcode.commands.permissions.ProcessResult;

public class DefaultPermissionGenerationStrategy
implements PermissionGenerationStrategy {
    @Override
    public ProcessResult processCommand(String currentPermission, String commandName) {
        if (currentPermission == null) {
            return new ProcessResult(commandName);
        }
        if (currentPermission.startsWith("$")) {
            ProcessResult result = new ProcessResult(currentPermission);
            result.setPermission(currentPermission.substring(1));
            return result;
        }
        if (!currentPermission.isEmpty()) {
            return new ProcessResult(currentPermission);
        }
        return new ProcessResult("");
    }

    @Override
    public ProcessResult processSubCommand(String previousPermissions, String currentPermission, String commandName) {
        if (currentPermission.startsWith("$")) {
            ProcessResult result = new ProcessResult(currentPermission);
            result.setPermission(currentPermission.substring(1));
            return result;
        }
        if (previousPermissions.startsWith("$")) {
            ProcessResult result = new ProcessResult(previousPermissions);
            result.setPermission(previousPermissions.substring(1));
            return result;
        }
        return new ProcessResult(previousPermissions + "." + currentPermission);
    }

    @Override
    public String processArgumentSet(String previousPermissions, String argumentPermission, String subCommandPermission) {
        if (previousPermissions.startsWith("$")) {
            return previousPermissions.substring(1);
        }
        if (argumentPermission != null && !argumentPermission.isEmpty()) {
            if (!previousPermissions.isEmpty()) {
                return previousPermissions + "." + argumentPermission;
            }
            return argumentPermission;
        }
        if (!previousPermissions.isEmpty()) {
            return previousPermissions;
        }
        return "";
    }
}

