/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.preconditions.processor;

import org.jetbrains.annotations.Nullable;
import ru.cwcode.commands.preconditions.processor.PreconditionRequirements;

public class PreconditionResult {
    private boolean canPerform = true;
    private boolean canSee = true;
    @Nullable
    private String cannotPerformMessage = null;

    PreconditionResult() {
    }

    public PreconditionResult(boolean canPerform, boolean canSee, @Nullable String cannotPerformMessage) {
        this.canPerform = canPerform;
        this.canSee = canSee;
        this.cannotPerformMessage = cannotPerformMessage;
    }

    public boolean canPerform() {
        return this.canPerform;
    }

    public boolean canSee() {
        return this.canSee;
    }

    @Nullable
    public String getCannotPerformMessage() {
        return this.cannotPerformMessage;
    }

    void setCanPerform(boolean canPerform) {
        this.canPerform = canPerform;
    }

    void setCanSee(boolean canSee) {
        this.canSee = canSee;
    }

    void setCannotPerformMessage(@Nullable String cannotPerformMessage) {
        this.cannotPerformMessage = cannotPerformMessage;
    }

    public boolean isSatisfy(PreconditionRequirements requirements) {
        return !(!this.canPerform && requirements.canPerform() || !this.canSee && requirements.canSee());
    }
}

