/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.arguments.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.CompletionStyle;
import ru.cwcode.commands.api.CommandsAPI;
import ru.cwcode.commands.api.Sender;

public class StringArg
extends Argument {
    static final int INITIAL_MAX_STRING_LENGTH = 10000;
    protected String placeholder = CommandsAPI.l10n.get("argument.string.placeholder", new Object[0]);
    int min = 1;
    int max = 10000;
    CompletionStyle style = CompletionStyle.PLACEHOLDER;
    Pattern pattern;

    public StringArg(String placeholder) {
        this.placeholder = placeholder;
    }

    public StringArg() {
    }

    public StringArg setMin(int min) {
        this.min = min;
        return this;
    }

    public StringArg setMax(int max) {
        this.max = max;
        return this;
    }

    public StringArg setStyle(CompletionStyle style) {
        this.style = style;
        return this;
    }

    public StringArg setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    public StringArg setPattern(Pattern pattern) {
        this.pattern = pattern;
        return this;
    }

    @Override
    public boolean valid(String raw) {
        if (raw.length() < this.min || raw.length() > this.max) {
            return false;
        }
        return this.pattern == null || this.pattern.matcher(raw).matches();
    }

    public List<String> completions(Sender sender) {
        if (Objects.requireNonNull(this.style) == CompletionStyle.PLACEHOLDER) {
            return Collections.singletonList(this.placeholder);
        }
        return Collections.emptyList();
    }

    @Override
    public String argumentName() {
        return this.placeholder;
    }

    @Override
    protected String hint() {
        boolean maxFlag;
        if (this.pattern != null) {
            return this.pattern.pattern();
        }
        boolean bl = maxFlag = this.max != 10000;
        if (maxFlag) {
            return CommandsAPI.l10n.get("argument.string.hint.minmax", new Object[]{this.min, this.max});
        }
        return CommandsAPI.l10n.get("argument.string.hint.min", new Object[]{this.min});
    }
}

