/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.executor;

import java.util.WeakHashMap;
import ru.cwcode.commands.ArgumentSet;
import ru.cwcode.commands.Command;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.commands.executor.AbstractExecutor;

public abstract class AbstractLocalTimedExecutor
extends AbstractExecutor {
    WeakHashMap<Sender, Long> lastExecutionTime = new WeakHashMap();
    long delay;

    public AbstractLocalTimedExecutor(long delayMillis) {
        this.delay = delayMillis;
    }

    @Override
    public void prepare(Sender sender, String[] args, ArgumentSet argumentSet, Command command) {
        if (this.lastExecutionTime.containsKey(sender)) {
            if (System.currentTimeMillis() - this.lastExecutionTime.get(sender) > this.delay) {
                this.lastExecutionTime.put(sender, System.currentTimeMillis());
                this.commandDelayPassed();
            } else {
                this.commandDelayNotPassed();
            }
        }
        super.prepare(sender, args, argumentSet, command);
    }

    @Override
    public void executeForPlayer() {
    }

    protected abstract void commandDelayNotPassed();

    protected abstract void commandDelayPassed();
}

