/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.arguments.basic;

import java.util.Arrays;
import java.util.List;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.api.CommandsAPI;
import ru.cwcode.commands.api.Sender;

public class BooleanArg
extends Argument {
    private String trueValue;
    private String falseValue;

    public BooleanArg() {
        this("true", "false");
    }

    public BooleanArg(String trueValue, String falseValue) {
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }

    @Override
    public Integer toInt() {
        if (this.notNull()) {
            return this.raw.equalsIgnoreCase(this.trueValue) ? 1 : 0;
        }
        return null;
    }

    @Override
    public String toString() {
        if (this.notNull()) {
            return this.raw.equalsIgnoreCase(this.trueValue) ? "true" : "false";
        }
        return null;
    }

    @Override
    public Double toDouble() {
        if (this.notNull()) {
            return this.raw.equalsIgnoreCase(this.trueValue) ? 1.0 : 0.0;
        }
        return null;
    }

    @Override
    public Boolean toBoolean() {
        if (this.notNull()) {
            return this.raw.equalsIgnoreCase(this.trueValue);
        }
        return null;
    }

    @Override
    public boolean valid(String raw) {
        return raw.equalsIgnoreCase(this.trueValue) || raw.equalsIgnoreCase(this.falseValue);
    }

    public List<String> completions(Sender sender) {
        return Arrays.asList(this.trueValue, this.falseValue);
    }

    @Override
    public String argumentName() {
        return this.trueValue + "/" + this.falseValue;
    }

    @Override
    public Object map() {
        return this.toBoolean();
    }

    @Override
    protected String hint() {
        return CommandsAPI.l10n.get("argument.boolean.hint", new Object[]{this.trueValue, this.falseValue});
    }

    public void setTrueValue(String trueValue) {
        this.trueValue = trueValue;
    }

    public void setFalseValue(String falseValue) {
        this.falseValue = falseValue;
    }
}

