/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.extra;

import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.commands.extra.command.argument.KeyArgument;

public class RepositoryAccessor<E, K, S extends Sender> {
    private final BiFunction<E, S, K> elementToKey;
    private final BiFunction<K, S, E> keyToElement;
    private final Function<K, String> keyToString;
    private final Function<String, K> stringToKey;
    private final Function<S, Collection<K>> keys;

    public RepositoryAccessor(BiFunction<E, S, K> elementToKey, BiFunction<K, S, E> keyToElement, Function<K, String> keyToString, Function<String, K> stringToKey, Function<S, Collection<K>> keys) {
        this.elementToKey = elementToKey;
        this.keyToElement = keyToElement;
        this.keyToString = keyToString;
        this.stringToKey = stringToKey;
        this.keys = keys;
    }

    public Collection<K> keys(S sender) {
        return this.keys.apply(sender);
    }

    public K elementToKey(E element, S sender) {
        return this.elementToKey.apply(element, sender);
    }

    public E keyToElement(S sender, K key) {
        return this.keyToElement.apply(key, sender);
    }

    public String keyToString(K key) {
        return this.keyToString.apply(key);
    }

    public K stringToKey(String string) {
        return this.stringToKey.apply(string);
    }

    public Argument keyArgument() {
        return new KeyArgument(this);
    }
}

