/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.arguments.basic;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.CompletionStyle;
import ru.cwcode.commands.api.CommandsAPI;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.cwutils.numbers.NumbersUtils;

public class DoubleArg
extends Argument {
    double min = -1.7976931348623157E308;
    double max = Double.MAX_VALUE;
    CompletionStyle style = CompletionStyle.PLACEHOLDER;
    double step = 1.0;
    String placeholder = CommandsAPI.l10n.get("argument.double.placeholder", new Object[0]);

    public DoubleArg(String placeholder) {
        this.placeholder = placeholder;
    }

    public DoubleArg() {
    }

    public DoubleArg setMin(double min) {
        this.min = min;
        return this;
    }

    public DoubleArg setMax(double max) {
        this.max = max;
        return this;
    }

    public DoubleArg setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    public DoubleArg setStyle(CompletionStyle style) {
        this.style = style;
        return this;
    }

    public DoubleArg setStep(double step) {
        this.step = step;
        return this;
    }

    public DoubleArg positive() {
        this.min = 0.0;
        return this;
    }

    @Override
    public boolean valid(String raw) {
        try {
            if (!NumbersUtils.isNumber((String)raw)) {
                return false;
            }
            double parsed = Double.parseDouble(raw);
            return parsed >= this.min && parsed < this.max;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public List<String> completions(Sender sender) {
        switch (this.style) {
            case PLACEHOLDER: {
                return Collections.singletonList(this.placeholder);
            }
            case DIAPASON: {
                return Collections.singletonList(this.min + " -> " + this.max);
            }
            case LIST: {
                return DoubleStream.iterate(this.min, d -> d <= this.max, d -> d + this.step).limit(1000L).mapToObj(Double::toString).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    @Override
    public String argumentName() {
        return this.placeholder;
    }

    @Override
    public Object map() {
        return this.toDouble();
    }

    @Override
    protected String hint() {
        boolean maxFlag;
        boolean minFlag = this.min > Double.MIN_VALUE;
        boolean bl = maxFlag = this.max < Double.MAX_VALUE;
        if (minFlag && maxFlag) {
            return CommandsAPI.l10n.get("argument.double.hint.minmax", new Object[]{this.min, this.max});
        }
        if (!minFlag && maxFlag) {
            return CommandsAPI.l10n.get("argument.double.hint.max", new Object[]{this.max});
        }
        if (minFlag && !maxFlag) {
            return CommandsAPI.l10n.get("argument.double.hint.min", new Object[]{this.min});
        }
        return this.placeholder;
    }
}

