/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.color;

import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.HSVLike;
import ru.cwcode.commands.color.ColorGenerationStrategy;

public class DynamicRainbowColorScheme
implements ColorGenerationStrategy {
    private static final TextColor main = TextColor.fromHexString((String)"#00a6f0");
    private static final TextColor argument = TextColor.fromHexString((String)"#00baff");
    private static final TextColor optional = TextColor.fromHexString((String)"#02d7ff");
    private static final TextColor subcommand = TextColor.fromHexString((String)"#0098dc");
    private static final TextColor written = TextColor.fromHexString((String)"#007ab5");
    private static final TextColor permissions = TextColor.fromHexString((String)"#055080");
    private static final TextColor accent = TextColor.fromHexString((String)"#8adaff");
    private static final TextColor argumentWithNoPermissions = TextColor.fromHexString((String)"#FF2C00");
    private static final TextColor optionalWithNoPermissions = TextColor.fromHexString((String)"#FF1800");
    private static final TextColor subcommandWithNoPermissions = TextColor.fromHexString((String)"#FF2C00");
    private static final TextColor writtenWithNoPermissions = TextColor.fromHexString((String)"#FF3100");
    private static final TextColor permissionsWithNoPermissions = TextColor.fromHexString((String)"#C83000");
    private static final TextColor accentWithNoPermissions = TextColor.fromHexString((String)"#FF9C84");
    public static DynamicRainbowColorScheme INSTANCE = new DynamicRainbowColorScheme();

    @Override
    public TextColor main() {
        return this.wrap(main);
    }

    @Override
    public TextColor argument(boolean canPerformedBy) {
        return this.wrap(canPerformedBy ? argument : argumentWithNoPermissions);
    }

    @Override
    public TextColor optional(boolean canPerformedBy) {
        return this.wrap(canPerformedBy ? optional : optionalWithNoPermissions);
    }

    @Override
    public TextColor subcommand(boolean canPerformedBy) {
        return this.wrap(canPerformedBy ? subcommand : subcommandWithNoPermissions);
    }

    @Override
    public TextColor written(boolean canPerformedBy) {
        return this.wrap(canPerformedBy ? written : writtenWithNoPermissions);
    }

    @Override
    public TextColor permissions(boolean canPerformedBy) {
        return this.wrap(canPerformedBy ? permissions : permissionsWithNoPermissions);
    }

    @Override
    public TextColor accent(boolean canPerformedBy) {
        return this.wrap(canPerformedBy ? accent : accentWithNoPermissions);
    }

    public TextColor wrap(TextColor color) {
        HSVLike hsvLike = color.asHSV();
        long time = System.nanoTime() % 3600000L;
        float h = (float)time / 3600000.0f;
        float sOffset = (double)h > 0.6 && (double)h < 0.8 ? -0.3f : 0.0f;
        HSVLike of = HSVLike.of((float)h, (float)(hsvLike.s() + sOffset), (float)Math.min(1.0f, hsvLike.v() - sOffset));
        return TextColor.color((HSVLike)of);
    }
}

