/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.ArgumentFitnessResult;
import ru.cwcode.commands.ArgumentSearchResult;
import ru.cwcode.commands.ArgumentSet;
import ru.cwcode.commands.DebugMode;
import ru.cwcode.commands.Help;
import ru.cwcode.commands.Permissible;
import ru.cwcode.commands.api.CommandsAPI;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.commands.color.ColorGenerationStrategy;
import ru.cwcode.commands.color.ColoredScheme;
import ru.cwcode.commands.color.DefaultColorGenerationStrategy;
import ru.cwcode.commands.executor.AbstractExecutor;
import ru.cwcode.commands.permissions.DefaultPermissionGenerationStrategy;
import ru.cwcode.commands.permissions.PermissionGenerationStrategy;
import ru.cwcode.commands.permissions.ProcessResult;
import ru.cwcode.commands.preconditions.CommandPreconditionResult;
import ru.cwcode.commands.preconditions.Precondition;
import ru.cwcode.commands.preconditions.PreconditionProcessor;
import ru.cwcode.commands.preconditions.PreconditionRequirements;
import ru.cwcode.commands.preconditions.PreconditionResult;
import ru.cwcode.commands.preconditions.impl.PermissionPrecondition;
import ru.cwcode.commands.preconditions.impl.PredicatePrecondition;

public class Command
implements Permissible {
    protected List<ArgumentSet> argumentSets = new ArrayList<ArgumentSet>();
    String name;
    ColorGenerationStrategy color = null;
    PermissionGenerationStrategy permissions = null;
    List<String> aliases = new ArrayList<String>();
    boolean isSubcommand = false;
    String description = null;
    String permission;
    Deque<Precondition> preconditions = new ArrayDeque<Precondition>();
    Help help;
    Command parent = null;
    Command[] subcommands = new Command[0];
    DebugMode debug = DebugMode.valueOf(CommandsAPI.getConfig().get("debug.default.mode", "NONE"));

    public Command(String name, List<String> aliases) {
        this(name);
        this.aliases(aliases);
    }

    public Command(String name) {
        this.name = name;
        this.permission = name;
    }

    public Command aliases(List<String> aliases) {
        this.aliases = aliases;
        return this;
    }

    public Command(String name, AbstractExecutor executor) {
        this(name);
        this.arguments(new ArgumentSet(executor, name, new Argument[0]));
    }

    public Command arguments(ArgumentSet ... arguments) {
        for (ArgumentSet set : arguments) {
            this.argumentSets.add(set);
            if (this.debug.is(DebugMode.DETAILED)) {
                this.debug.print(CommandsAPI.l10n.get("command.debug.registeredArgumentSet", new Object[]{this.name, set}));
            }
            if (set.optionalStart < 0) continue;
            for (int i = set.arguments.length - 1; i >= set.optionalStart; --i) {
                this.argumentSets.add(new ArgumentSet(set, Arrays.copyOfRange(set.arguments, 0, i)).hidden());
                if (!this.debug.is(DebugMode.DETAILED)) continue;
                this.debug.print(CommandsAPI.l10n.get("command.debug.optionalAdapt", new Object[]{set}));
            }
        }
        return this;
    }

    public Command(String name, String permission, AbstractExecutor executor) {
        this(name, permission);
        this.arguments(new ArgumentSet(executor, permission, new Argument[0]));
    }

    public Command(String name, String permission) {
        this(name);
        this.permission = permission;
    }

    public Command(String name, AbstractExecutor executor, Argument ... arguments) {
        this(name);
        this.arguments(new ArgumentSet(executor, "", arguments));
    }

    @Deprecated(forRemoval=true)
    public Command setIgnoreExecutionPossibility(boolean ignoreExecutionPossibility) {
        return this;
    }

    public Command aliases(String ... aliases) {
        this.aliases = List.of(aliases);
        return this;
    }

    public List<String> aliases() {
        return this.aliases;
    }

    public Command subCommands(Command ... subcommands) {
        this.subcommands = subcommands;
        for (Command subcommand : subcommands) {
            subcommand.isSubcommand = true;
            subcommand.parent = this;
            subcommand.debug = this.debug;
            if (!this.debug.is(DebugMode.DETAILED)) continue;
            this.debug.print(CommandsAPI.l10n.get("command.debug.registeredSubcommand", new Object[]{this.getName(), subcommand.getName()}));
        }
        return this;
    }

    public void register() {
        if (this.isSubcommand) {
            return;
        }
        if (this.debug != DebugMode.NONE) {
            this.updateDebug(this.debug);
        }
        if (this.permissions == null) {
            this.permissions = new DefaultPermissionGenerationStrategy();
        }
        if (this.color == null) {
            this.color = DefaultColorGenerationStrategy.INSTANCE;
        }
        this.name = this.name.toLowerCase();
        this.updatePermissions(this.permission);
        CommandsAPI.getPlatform().registerCommand(this);
    }

    public void clearArgumentSets() {
        this.argumentSets.clear();
    }

    public Command help(Help help) {
        this.help = help;
        return this;
    }

    public Command description(String shortDescription) {
        this.description = shortDescription;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Command debug(DebugMode mode) {
        this.debug = mode;
        return this;
    }

    public Command getRootCommand() {
        if (this.isSubcommand) {
            return this.parent.getRootCommand();
        }
        return this;
    }

    public ColorGenerationStrategy getColorScheme() {
        if (this.color == null) {
            return this.parent.getColorScheme();
        }
        return this.color;
    }

    public Command setColorScheme(ColorGenerationStrategy colorGenerationStrategy) {
        this.color = colorGenerationStrategy;
        return this;
    }

    public Command setColorScheme(TextColor color) {
        this.setColorScheme(new ColoredScheme(color));
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Command setName(String name) {
        if (this.isSubcommand) {
            this.name = name;
        }
        return this;
    }

    @Override
    public String getPermission() {
        return this.permission;
    }

    PermissionGenerationStrategy getPermissions() {
        if (this.permissions == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getPermissions();
        }
        return this.permissions;
    }

    public Command setPermissions(PermissionGenerationStrategy strategy) {
        this.permissions = strategy;
        return this;
    }

    public Command canExecute(Predicate<Sender> canExecute) {
        this.preconditions.add(new PredicatePrecondition(canExecute));
        return this;
    }

    public Command preconditions(Precondition ... preconditions) {
        this.preconditions.addAll(Arrays.asList(preconditions));
        return this;
    }

    protected void updatePermissions(String permissions) {
        ProcessResult result;
        if (this.isSubcommand) {
            result = this.getPermissions().processSubCommand(permissions, this.permission, this.name);
            if (this.debug.is(DebugMode.DETAILED)) {
                this.debug.print(CommandsAPI.l10n.get("command.debug.subcommandPermissionSet", new Object[]{this.name, result.getPermission()}));
            }
        } else {
            result = this.getPermissions().processCommand(this.permission, this.name);
            if (this.debug.is(DebugMode.DETAILED)) {
                this.debug.print(CommandsAPI.l10n.get("command.debug.commandPermissionSet", new Object[]{this.name, result.getPermission()}));
            }
        }
        permissions = result.getNextPermissions();
        this.permission = result.getPermission();
        this.updatePermissionPrecondition();
        for (Command subcommand : this.subcommands) {
            subcommand.updatePermissions(permissions);
        }
        for (ArgumentSet argumentSet : this.argumentSets) {
            argumentSet.permission = this.getPermissions().processArgumentSet(permissions, argumentSet.permission, this.permission);
            argumentSet.updatePermissionPrecondition();
            if (!this.debug.is(DebugMode.DETAILED)) continue;
            this.debug.print(CommandsAPI.l10n.get("command.debug.argumentSetPermissionSet", new Object[]{this.name + String.valueOf(argumentSet), argumentSet.permission}));
        }
    }

    private void updatePermissionPrecondition() {
        for (Precondition precondition : this.preconditions) {
            if (!(precondition instanceof PermissionPrecondition)) continue;
            return;
        }
        this.preconditions.addFirst(new PermissionPrecondition(this));
    }

    protected void onExecute(Sender sender, String[] args, ArgumentSet founded) {
        long start = System.nanoTime();
        founded.execute(sender, args, this);
        if (this.debug.is(DebugMode.REDUCED)) {
            this.debug.print(CommandsAPI.l10n.get("command.debug.executionTook", new Object[]{founded, System.nanoTime() - start, (System.nanoTime() - start) / 1000000L}));
        }
    }

    protected List<Command> getSubcommandsFor(Sender sender, PreconditionRequirements requirements) {
        ArrayList<Command> list = new ArrayList<Command>();
        for (Command command : this.subcommands) {
            if (!command.checkPreconditions(sender, requirements)) continue;
            list.add(command);
        }
        return list;
    }

    protected boolean canPerformedBy(Sender sender) {
        return this.checkPreconditions(sender).getResult().canPerform();
    }

    protected CommandPreconditionResult checkPreconditions(Sender sender) {
        return new CommandPreconditionResult(this, PreconditionProcessor.process(sender, this.preconditions));
    }

    protected boolean checkPreconditions(Sender sender, PreconditionRequirements requirements) {
        return PreconditionProcessor.process(sender, this.preconditions).isSatisfy(requirements);
    }

    protected Command getSubcommandFor(String arg, Sender sender) {
        for (Command command : this.subcommands) {
            if (!command.name.equalsIgnoreCase(arg) && !command.aliases.contains(arg) || !command.checkPreconditions(sender, PreconditionRequirements.CAN_PERFORM_AND_CAN_SEE)) continue;
            return command;
        }
        return null;
    }

    protected List<ArgumentSet> getArgumentSetsFor(Sender sender, PreconditionRequirements requirements) {
        ArrayList<ArgumentSet> list = new ArrayList<ArgumentSet>();
        for (ArgumentSet arg : this.argumentSets) {
            if (!arg.checkPreconditions(sender, requirements)) continue;
            list.add(arg);
        }
        return list;
    }

    protected ArgumentSearchResult searchForArgumentSet(Sender sender, String ... args) {
        ArgumentSearchResult result = new ArgumentSearchResult();
        for (ArgumentSet set : this.argumentSets) {
            PreconditionResult preconditionResult = set.checkPreconditions(sender);
            ArgumentFitnessResult fitnessResult = set.isArgumentsFit(sender, args);
            String errorMessage = null;
            if (!preconditionResult.canPerform()) {
                if (preconditionResult.getCannotPerformMessage() == null) continue;
                errorMessage = preconditionResult.getCannotPerformMessage();
            }
            if (fitnessResult.success()) {
                if (errorMessage == null) {
                    return result.founded(set);
                }
                return result.error(set, errorMessage);
            }
            if (!preconditionResult.canSee()) continue;
            result.add(fitnessResult);
        }
        return result;
    }

    protected void onError(Sender sender, String label, String[] args, ArgumentSearchResult argumentSearchResult) {
        if (this.help != null) {
            this.help.sendTo(sender, this, label, args);
            return;
        }
        if (argumentSearchResult.getErrorMessage() != null) {
            this.showErrorMessage(sender, label, argumentSearchResult);
        } else if (argumentSearchResult.canShowDetailedHelp()) {
            this.showDetailedHelp(sender, label, argumentSearchResult);
        } else {
            this.showFullHelp(sender, label, args);
        }
    }

    private void showErrorMessage(Sender sender, String label, ArgumentSearchResult argumentSearchResult) {
        ArrayList<Object> toSend = new ArrayList<Object>();
        toSend.add(Component.empty());
        toSend.add(argumentSearchResult.getFounded().toComponent(sender, this.getColorScheme()));
        toSend.add(((TextComponent)Component.text((String)"\u21b3 ").append((Component)Component.text((String)argumentSearchResult.getErrorMessage()))).color(this.getColorScheme().accent(true)));
        toSend.add(Component.empty());
        for (Component component : toSend) {
            sender.sendMessage(component);
        }
    }

    protected void showFullHelp(Sender sender, String label, String[] args) {
        if (this.help == null) {
            this.sendAutoHelp(sender, label, args);
        } else {
            this.help.sendTo(sender, this, label, args);
        }
    }

    private void updateDebug(DebugMode debug) {
        this.debug = debug;
        for (Command subcommand : this.subcommands) {
            subcommand.updateDebug(debug);
        }
    }

    private void showDetailedHelp(Sender sender, String label, ArgumentSearchResult argumentSearchResult) {
        TextComponent written = Component.text((String)("  /" + this.getFullCommandPath(label)), (TextColor)this.getColorScheme().written(true));
        ArrayList<Object> toSend = new ArrayList<Object>();
        toSend.add(Component.empty());
        for (ArgumentFitnessResult argumentFitnessResult : argumentSearchResult.getInvalidResults()) {
            ArgumentSet argumentSet = argumentFitnessResult.getArgumentSet();
            if (argumentSet.hasHelp()) {
                toSend.add(argumentSet.help);
            } else {
                toSend.add(written.append(argumentSet.toComponent(sender, this.getColorScheme())));
                toSend.add(((TextComponent)Component.text((String)"\u21b3 ").append(argumentFitnessResult.getInvalidArgument().invalidMessage(this, sender, argumentFitnessResult.getInvalidStringArgument()))).color(this.getColorScheme().accent(true)));
            }
            toSend.add(Component.empty());
        }
        for (Component component : toSend) {
            sender.sendMessage(component);
        }
    }

    private void sendAutoHelp(Sender sender, String label, String[] args) {
        ColorGenerationStrategy color = this.getColorScheme();
        TextComponent written = Component.text((String)("  /" + this.getFullCommandPath(label)));
        ArrayList<Object> toSend = new ArrayList<Object>();
        for (Command subcommand : this.getSubcommandsFor(sender, PreconditionRequirements.ONLY_CAN_SEE)) {
            boolean bl = subcommand.canPerformedBy(sender);
            toSend.add(written.color(color.written(bl)).append((Component)Component.text((String)(" " + subcommand.name + " "), (TextColor)color.subcommand(bl))).append((Component)(sender.isOp() ? Component.text((String)subcommand.permission, (TextColor)color.permissions(bl)) : Component.empty())));
        }
        boolean previousWasEmptyLine = false;
        for (ArgumentSet argumentSet : this.filterArgumentSets(this.getArgumentSetsFor(sender, PreconditionRequirements.ONLY_CAN_SEE), args)) {
            if (argumentSet.isHidden()) continue;
            boolean canPerformedBy = argumentSet.canPerformedBy(sender);
            boolean hasHelp = argumentSet.hasHelp();
            if (!previousWasEmptyLine && hasHelp) {
                toSend.add(Component.empty());
            }
            toSend.add(written.color(color.written(canPerformedBy)).append(argumentSet.toComponent(sender, color)));
            if (hasHelp) {
                toSend.add(((TextComponent)Component.text((String)"\u21b3 ").append(argumentSet.help)).color(color.accent(canPerformedBy)));
                toSend.add(Component.empty());
                previousWasEmptyLine = true;
                continue;
            }
            previousWasEmptyLine = false;
        }
        this.sendDescription(sender, color);
        sender.sendMessage("");
        if (toSend.isEmpty()) {
            sender.sendMessage((Component)Component.text((String)CommandsAPI.l10n.get("command.noContinuation", new Object[0]), (TextColor)color.main()));
        } else {
            sender.sendMessage((Component)Component.text((String)CommandsAPI.l10n.get("command.continuations", new Object[0]), (TextColor)color.main()));
            sender.sendMessage("");
            for (Component component : toSend) {
                sender.sendMessage(component);
            }
        }
    }

    private List<ArgumentSet> filterArgumentSets(List<ArgumentSet> argumentSets, String[] args) {
        if (args.length == 0) {
            return argumentSets;
        }
        List<ArgumentSet> relevantArgumentSets = argumentSets.stream().filter(x -> x.shouldShowInHelp(List.of(args))).collect(Collectors.toList());
        if (relevantArgumentSets.isEmpty()) {
            return argumentSets;
        }
        return relevantArgumentSets;
    }

    private void sendDescription(Sender sender, ColorGenerationStrategy color) {
        if (this.description != null) {
            sender.sendMessage("");
            sender.sendMessage((Component)Component.text((String)CommandsAPI.l10n.get("command.description", new Object[0]), (TextColor)color.main()));
            boolean firstLine = true;
            for (String part : this.description.split("\n")) {
                sender.sendMessage((Component)Component.text((String)((firstLine ? "\u21b3 " : "  ") + part), (TextColor)color.accent(true)));
                firstLine = false;
            }
        }
    }

    @NotNull
    public String getFullCommandPath(String label) {
        StringBuilder writtenString = new StringBuilder();
        Command rootCommand = this;
        while (rootCommand.isSubcommand) {
            writtenString.insert(0, " " + rootCommand.name);
            rootCommand = rootCommand.parent;
        }
        writtenString.insert(0, label);
        return writtenString.toString();
    }

    private int getCommandPathLength() {
        int length = 0;
        Command parent = this;
        while (parent != null) {
            ++length;
            parent = parent.parent;
        }
        return length;
    }
}

