/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.extra.command.argument;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.commands.extra.RepositoryAccessor;

public class KeyArgument<E, K, S extends Sender>
extends Argument {
    private final RepositoryAccessor<E, K, S> repositoryAccessor;

    public KeyArgument(RepositoryAccessor<E, K, S> repositoryAccessor) {
        this.repositoryAccessor = repositoryAccessor;
    }

    @Override
    public boolean valid(String raw) {
        return false;
    }

    @Override
    public boolean valid(Sender sender, String raw, List<String> arguments) {
        return this.repositoryAccessor.keys(sender).contains(this.repositoryAccessor.stringToKey(raw));
    }

    @Override
    public Collection<String> completions(Sender sender) {
        return this.repositoryAccessor.keys(sender).stream().map(this.repositoryAccessor::keyToString).collect(Collectors.toList());
    }

    @Override
    public String argumentName() {
        return "ID";
    }
}

