/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CountedSet<T> {
    HashMap<T, Integer> map;

    public CountedSet(Collection<T> items) {
        this.map = new HashMap();
        for (T x : items) {
            this.map.put(x, this.map.getOrDefault(x, 0) + 1);
        }
    }

    public CountedSet(HashMap<T, Integer> map) {
        this.map = map;
    }

    public Set<T> items() {
        return this.map.keySet();
    }

    public Collection<Integer> values() {
        return this.map.values();
    }

    public int quantity(T item) {
        return this.map.getOrDefault(item, 0);
    }

    public boolean has(T item) {
        return this.map.containsKey(item);
    }

    public int add(T item, int count) {
        this.map.put(item, this.map.getOrDefault(item, 0) + count);
        return this.map.get(item);
    }

    public int max() {
        int best = 0;
        for (int value : this.map.values()) {
            if (value <= best) continue;
            best = value;
        }
        return best;
    }

    public int min() {
        int min2 = 0;
        for (int value : this.map.values()) {
            if (value >= min2) continue;
            min2 = value;
        }
        return min2;
    }

    public Map.Entry<T, Integer> minEntry() {
        Map.Entry<T, Integer> min2 = null;
        for (Map.Entry<T, Integer> value : this.map.entrySet()) {
            if (min2 != null && value.getValue() >= min2.getValue()) continue;
            min2 = value;
        }
        return min2;
    }

    public Map.Entry<T, Integer> maxEntry() {
        Map.Entry<T, Integer> max = null;
        for (Map.Entry<T, Integer> value : this.map.entrySet()) {
            if (max != null && value.getValue() <= max.getValue()) continue;
            max = value;
        }
        return max;
    }

    public int sum() {
        int sum = 0;
        for (int value : this.map.values()) {
            sum += value;
        }
        return sum;
    }

    public double avg() {
        long sum = 0L;
        long count = 0L;
        for (int x : this.map.values()) {
            sum += (long)x;
            ++count;
        }
        return count > 0L ? (double)sum / (double)count : 0.0;
    }

    public HashMap<T, Integer> entries() {
        return this.map;
    }
}

