/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.dynamicBossBar.broadcast;

import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ru.cwcode.cwutils.dynamicBossBar.broadcast.BroadcastBossBar;
import ru.cwcode.cwutils.dynamicBossBar.broadcast.BroadcastBossBar_v1_16_5;
import ru.cwcode.cwutils.server.ServerUtils;

public class BroadcastBossBarBuilder {
    private UUID uuid = UUID.randomUUID();
    private Supplier<Component> title;
    private Supplier<Float> progress = () -> Float.valueOf(1.0f);
    private Supplier<Boolean> shouldRemove;
    private Function<Player, Boolean> shouldDisplay = player -> true;
    private Supplier<BossBar.Color> color = () -> BossBar.Color.WHITE;
    private Supplier<BossBar.Overlay> overlay = () -> BossBar.Overlay.PROGRESS;
    private Supplier<Collection<UUID>> viewers = Collections::emptySet;

    public BroadcastBossBarBuilder setUuid(@NotNull UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    public BroadcastBossBarBuilder setViewers(Supplier<Collection<UUID>> viewers) {
        this.viewers = viewers;
        return this;
    }

    public BroadcastBossBarBuilder setTitle(@NotNull Supplier<Component> title) {
        this.title = title;
        return this;
    }

    public BroadcastBossBarBuilder setProgress(@NotNull Supplier<Float> progress) {
        this.progress = progress;
        return this;
    }

    public BroadcastBossBarBuilder setShouldRemove(@NotNull Supplier<Boolean> shouldRemove) {
        this.shouldRemove = shouldRemove;
        return this;
    }

    public BroadcastBossBarBuilder setShouldDisplay(@NotNull Function<Player, Boolean> shouldDisplay) {
        this.shouldDisplay = shouldDisplay;
        return this;
    }

    public BroadcastBossBarBuilder setColor(@NotNull Supplier<BossBar.Color> color) {
        this.color = color;
        return this;
    }

    public BroadcastBossBarBuilder setOverlay(@NotNull Supplier<BossBar.Overlay> overlay) {
        this.overlay = overlay;
        return this;
    }

    public BroadcastBossBar build() {
        return ServerUtils.isVersionGreater_1_16_5() ? new BroadcastBossBar(this.uuid, this.title, this.progress, this.shouldRemove, this.shouldDisplay, this.color, this.overlay, this.viewers) : new BroadcastBossBar_v1_16_5(this.uuid, this.title, this.progress, this.shouldRemove, this.shouldDisplay, this.color, this.overlay, this.viewers);
    }
}

