/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.event;

import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class EventHandler<E extends Event>
implements Listener {
    private boolean isUnregister = false;

    public EventHandler(Class<? extends Event> eventClass, TemporaryEvent<E> event, @NotNull Plugin plugin) {
        this(eventClass, EventPriority.NORMAL, plugin, event);
    }

    public EventHandler(Class<? extends Event> eventClass, EventPriority priority, @NotNull Plugin plugin, TemporaryEvent<E> event) {
        Bukkit.getServer().getPluginManager().registerEvent(eventClass, (Listener)this, priority, (ignored, ev) -> {
            try {
                event.use(ev);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }, plugin);
    }

    public EventHandler(Class<? extends Event> eventClass, @NotNull Plugin plugin, TemporaryEventAutoUnregister<E> event) {
        this(eventClass, EventPriority.NORMAL, plugin, event);
    }

    public EventHandler(Class<? extends Event> eventClass, EventPriority priority, @NotNull Plugin plugin, TemporaryEventAutoUnregister<E> event) {
        Bukkit.getServer().getPluginManager().registerEvent(eventClass, (Listener)this, priority, (ignored, ev) -> {
            try {
                if (this.isUnregister) {
                    return;
                }
                this.unregister(event.use(ev));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }, plugin);
    }

    public void unregister(boolean bool) {
        if (bool) {
            this.unregister();
        }
    }

    public void unregister() {
        HandlerList.unregisterAll((Listener)this);
        this.isUnregister = true;
    }

    public boolean isUnregister() {
        return this.isUnregister;
    }

    public static interface TemporaryEvent<E extends Event> {
        public void use(E var1);
    }

    public static interface TemporaryEventAutoUnregister<E extends Event> {
        public boolean use(E var1);
    }
}

