/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.location;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import ru.cwcode.cwutils.numbers.Rand;
import ru.cwcode.cwutils.particles.ParticlesUtils;

public class LocationUtils {
    public static Location randomLocation(Location pos1, Location pos2) {
        int x1 = Math.min(pos1.getBlockX(), pos2.getBlockX());
        int y1 = Math.min(pos1.getBlockY(), pos2.getBlockY());
        int z1 = Math.min(pos1.getBlockZ(), pos2.getBlockZ());
        int x2 = Math.max(pos1.getBlockX(), pos2.getBlockX());
        int y2 = Math.max(pos1.getBlockY(), pos2.getBlockY());
        int z2 = Math.max(pos1.getBlockZ(), pos2.getBlockZ());
        return new Location(pos1.getWorld(), (double)(Rand.ofInt(x2 - x1 + 1) + x1), (double)(Rand.ofInt(y2 - y1 + 1) + y1), (double)(Rand.ofInt(z2 - z1 + 1) + z1));
    }

    public static List<Block> getAllBlocksBetween(Location pos1, Location pos2) {
        if (pos1.getWorld() != pos2.getWorld()) {
            Bukkit.getLogger().warning("getAllBlocksBetween(Location pos1, Location pos2) got positions in different dimensions");
            return List.of();
        }
        int xMin = Math.min(pos1.getBlockX(), pos2.getBlockX());
        int yMin = Math.min(pos1.getBlockY(), pos2.getBlockY());
        int zMin = Math.min(pos1.getBlockZ(), pos2.getBlockZ());
        int xMax = Math.max(pos1.getBlockX(), pos2.getBlockX());
        int yMax = Math.max(pos1.getBlockY(), pos2.getBlockY());
        int zMax = Math.max(pos1.getBlockZ(), pos2.getBlockZ());
        World world = pos1.getWorld();
        ArrayList<Block> blocks = new ArrayList<Block>((Math.abs(xMin) - Math.abs(xMax)) * (Math.abs(yMin) - Math.abs(yMax)) * (Math.abs(zMin) - Math.abs(zMax)));
        for (int y = yMin; y <= yMax; ++y) {
            for (int z = zMin; z <= zMax; ++z) {
                for (int x = xMin; x <= xMax; ++x) {
                    blocks.add(world.getBlockAt(x, y, z));
                }
            }
        }
        return blocks;
    }

    public static Location getHighestLocationUnder(Location location) {
        double minHeight = location.getWorld().getMinHeight();
        while (location.getY() >= minHeight && location.getBlock().getType().isAir()) {
            location.subtract(0.0, 1.0, 0.0);
        }
        return location.add(0.0, 1.0, 0.0);
    }

    public static Collection<LivingEntity> getEntitiesInRadius(Location location, double radius, boolean thruBlocks) {
        Stream<Object> stream = location.getNearbyLivingEntities(radius).stream();
        if (!thruBlocks) {
            stream = stream.filter(x -> !LocationUtils.hasBlockBetweenLocations(location, x.getLocation()));
        }
        return stream.collect(Collectors.toList());
    }

    public static boolean hasBlockBetweenLocations(Location pos1, Location pos2) {
        if (!pos1.getWorld().equals(pos2.getWorld())) {
            Bukkit.getLogger().warning("hasBlockBetweenLocations(Location pos1, Location pos2) got positions in different dimensions");
            return true;
        }
        Vector direction = pos2.toVector().subtract(pos1.toVector()).normalize();
        double distance = pos1.distance(pos2);
        RayTraceResult result = pos1.getWorld().rayTraceBlocks(pos1, direction, distance, FluidCollisionMode.NEVER, true);
        if (result == null) {
            return false;
        }
        return result.getHitBlock() != null && !result.getHitBlock().getType().isAir();
    }

    public static boolean hasEntityAtLocation(Location location, boolean onlyAlive) {
        for (Entity entity : location.getChunk().getEntities()) {
            if (onlyAlive && !entity.getType().isAlive() || !entity.getBoundingBox().contains(location.toVector())) continue;
            return true;
        }
        return false;
    }

    public static <T extends Entity> Optional<T> getEntityAtLocation(Location location, Class<T> entityClass) {
        for (Entity entity : location.getChunk().getEntities()) {
            if (!entity.getClass().isAssignableFrom(entityClass) || !entity.getBoundingBox().contains(location.toVector())) continue;
            return Optional.of(entity);
        }
        return Optional.empty();
    }

    public static Collection<Entity> getEntitiesBetween(Location pos1, Location pos2) {
        if (!pos1.getWorld().equals(pos2.getWorld())) {
            Bukkit.getLogger().warning("getEntitiesBetween(Location pos1, Location pos2) got positions in different dimensions");
            return List.of();
        }
        BoundingBox boundingBox = new BoundingBox((double)pos1.getBlockX(), (double)pos1.getBlockY(), (double)pos1.getBlockZ(), (double)pos2.getBlockX(), (double)pos2.getBlockY(), (double)pos2.getBlockZ());
        return pos1.getWorld().getNearbyEntities(boundingBox);
    }

    public static boolean isIn(Location locationToTest, Chunk chunk) {
        return Chunk.getChunkKey((Location)locationToTest) == chunk.getChunkKey();
    }

    public static boolean isInRegion(Location tested, Location pos1, Location pos2) {
        if (!tested.getWorld().equals(pos1.getWorld()) || !tested.getWorld().equals(pos2.getWorld())) {
            return false;
        }
        double x1 = Math.min(pos1.getX(), pos2.getX());
        double y1 = Math.min(pos1.getY(), pos2.getY());
        double z1 = Math.min(pos1.getZ(), pos2.getZ());
        double x2 = Math.max(pos1.getX(), pos2.getX());
        double y2 = Math.max(pos1.getY(), pos2.getY());
        double z2 = Math.max(pos1.getZ(), pos2.getZ());
        double x = tested.getX();
        double y = tested.getY();
        double z = tested.getZ();
        return x >= x1 && x <= x2 && y >= y1 && y <= y2 && z >= z1 && z <= z2;
    }

    public static float getYawRotatedToGiven(float yaw) {
        return Location.normalizeYaw((float)(Math.round(yaw / 90.0f) * 90 - 180));
    }

    public static BlockFace getBlockFaceFromYaw(float yaw) {
        switch (Math.round((180.0f + yaw) / 90.0f)) {
            case 0: {
                return BlockFace.NORTH;
            }
            case 1: {
                return BlockFace.EAST;
            }
            case 2: {
                return BlockFace.SOUTH;
            }
            case 3: {
                return BlockFace.WEST;
            }
        }
        throw new IllegalStateException("Unexpected value: " + Math.round((180.0f + yaw) / 90.0f));
    }

    public static boolean validateAir(Location location) {
        if (location.getBlock().getType().isAir()) {
            return true;
        }
        ParticlesUtils.drawHollowCuboid(location, location.clone().add(1.0, 1.0, 1.0), Particle.ASH, 0.2);
        return false;
    }

    public static boolean validateSolid(Location location) {
        if (location.getBlock().getType().isSolid()) {
            return true;
        }
        ParticlesUtils.drawHollowCuboid(location, location.clone().add(1.0, 1.0, 1.0), Particle.ASH, 0.2);
        return false;
    }

    public static boolean validateNoEntities(Location pos1, Location pos2) {
        Collection nearbyEntities = pos1.getWorld().getNearbyEntities(BoundingBox.of((Location)pos1, (Location)pos2));
        if (!nearbyEntities.isEmpty()) {
            ParticlesUtils.drawHollowCuboid(pos1, pos2, Particle.ASH, 0.2);
            return false;
        }
        return true;
    }

    public static Vector getCoordinatesInsideChunk(Location location) {
        int x = location.getBlockX() & 0xF;
        int y = location.getBlockY();
        int z = location.getBlockZ() & 0xF;
        return new Vector(x, y, z);
    }
}

