/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.scheduler;

import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import ru.cwcode.cwutils.scheduler.AbstractScheduler;
import ru.cwcode.cwutils.scheduler.Tasks;

public class VoidScheduler
extends AbstractScheduler {
    JavaPlugin registrant = null;
    private volatile Runnable action = () -> {};
    private volatile Runnable lastlyAction = () -> {};
    private volatile Supplier<Boolean> condition = null;

    private VoidScheduler() {
    }

    public static VoidScheduler create() {
        return new VoidScheduler();
    }

    public VoidScheduler perform(Runnable action) {
        this.action = action;
        return this;
    }

    public VoidScheduler until(Supplier<Boolean> condition) {
        this.condition = condition;
        return this;
    }

    public VoidScheduler async() {
        this.asyncTask = true;
        this.blocked = true;
        return this;
    }

    public VoidScheduler async(boolean async) {
        this.asyncTask = async;
        this.blocked = async || this.blocked;
        return this;
    }

    public VoidScheduler infinite() {
        this.infinite = true;
        return this;
    }

    public VoidScheduler infinite(boolean infinite) {
        this.infinite = infinite;
        return this;
    }

    public VoidScheduler otherwise(Runnable lastlyAction) {
        this.lastlyAction = lastlyAction;
        return this;
    }

    public BukkitTask registerTask(JavaPlugin plugin, long delay) {
        BukkitTask task = this.asyncTask ? Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, this::tick, delay, delay) : Bukkit.getScheduler().runTaskTimer((Plugin)plugin, this::tick, delay, delay);
        this.registrant = plugin;
        this.taskId = task.getTaskId();
        Tasks.put(this.id, this);
        return task;
    }

    public int register(JavaPlugin plugin, long delay) {
        return this.registerTask(plugin, delay).getTaskId();
    }

    private void tick() {
        if (this.blocked && this.running) {
            return;
        }
        if (this.condition == null) {
            this.runWithCancelling(this.action);
        } else if (this.condition.get().booleanValue()) {
            this.run(this.action);
        } else {
            this.runWithCancelling(this.lastlyAction);
        }
    }

    private void runWithCancelling(Runnable action) {
        try {
            this.running = true;
            action.run();
            if (!this.infinite) {
                Tasks.cancelTask(this.id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.running = false;
        }
    }

    private void run(Runnable action) {
        try {
            this.running = true;
            action.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.running = false;
        }
    }
}

