/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.ArgumentFitnessResult;
import ru.cwcode.commands.ArgumentSearchResult;
import ru.cwcode.commands.ArgumentSet;
import ru.cwcode.commands.DebugMode;
import ru.cwcode.commands.Help;
import ru.cwcode.commands.Permissible;
import ru.cwcode.commands.api.CommandsAPI;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.commands.color.ColorGenerationStrategy;
import ru.cwcode.commands.color.ColoredScheme;
import ru.cwcode.commands.color.DefaultColorGenerationStrategy;
import ru.cwcode.commands.executor.AbstractExecutor;
import ru.cwcode.commands.permissions.DefaultPermissionGenerationStrategy;
import ru.cwcode.commands.permissions.PermissionGenerationStrategy;
import ru.cwcode.commands.permissions.ProcessResult;
import ru.cwcode.commands.preconditions.CommandPreconditionResult;
import ru.cwcode.commands.preconditions.Precondition;
import ru.cwcode.commands.preconditions.PredicatePrecondition;
import ru.cwcode.commands.preconditions.processor.PermissionPrecondition;
import ru.cwcode.commands.preconditions.processor.PreconditionProcessor;
import ru.cwcode.commands.preconditions.processor.PreconditionRequirements;
import ru.cwcode.commands.preconditions.processor.PreconditionResult;

public class Command
implements Permissible {
    protected List<ArgumentSet> argumentSets = new ArrayList<ArgumentSet>();
    String name;
    ColorGenerationStrategy color = null;
    PermissionGenerationStrategy permissions = null;
    List<String> aliases = new ArrayList<String>();
    boolean isSubcommand = false;
    String description = null;
    String permission;
    Deque<Precondition> preconditions = new ArrayDeque<Precondition>();
    Help help;
    Command parent = null;
    Command[] subcommands = new Command[0];
    DebugMode debug = DebugMode.NONE;

    public Command(String name, List<String> aliases) {
        this(name);
        this.aliases(aliases);
    }

    public Command(String name) {
        this.name = name;
        this.permission = name;
    }

    public Command aliases(List<String> aliases) {
        this.aliases = aliases;
        return this;
    }

    public Command(String name, AbstractExecutor executor) {
        this(name);
        this.arguments(new ArgumentSet(executor, name, new Argument[0]));
    }

    public Command arguments(ArgumentSet ... arguments) {
        for (ArgumentSet set : arguments) {
            this.argumentSets.add(set);
            if (this.debug.is(DebugMode.DETAILED)) {
                this.debug.print("\u00a77\u0412 \u00a7f" + this.name + "\u00a77 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0441\u0435\u0442 \u00a7f" + set);
            }
            if (set.optionalStart <= 0) continue;
            for (int i = set.arguments.length - 1; i >= set.optionalStart; --i) {
                this.argumentSets.add(new ArgumentSet(set, Arrays.copyOfRange(set.arguments, 0, i)).hidden());
                if (!this.debug.is(DebugMode.DETAILED)) continue;
                this.debug.print("\u00a77\u0410\u0434\u0430\u043f\u0442\u0430\u0446\u0438\u044f \u043e\u043f\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u0445 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u0432: \u00a7f" + set);
            }
        }
        return this;
    }

    public Command(String name, String permission, AbstractExecutor executor) {
        this(name, permission);
        this.arguments(new ArgumentSet(executor, name, new Argument[0]));
    }

    public Command(String name, String permission) {
        this(name);
        this.permission = permission;
    }

    public Command(String name, AbstractExecutor executor, Argument ... arguments) {
        this(name);
        this.arguments(new ArgumentSet(executor, "", arguments));
    }

    @Deprecated(forRemoval=true)
    public Command setIgnoreExecutionPossibility(boolean ignoreExecutionPossibility) {
        return this;
    }

    public Command aliases(String ... aliases) {
        this.aliases = List.of(aliases);
        return this;
    }

    public List<String> aliases() {
        return this.aliases;
    }

    public Command subCommands(Command ... subcommands) {
        this.subcommands = subcommands;
        for (Command subcommand : subcommands) {
            subcommand.isSubcommand = true;
            subcommand.parent = this;
            subcommand.debug = this.debug;
            if (!this.debug.is(DebugMode.DETAILED)) continue;
            this.debug.print("\u00a77\u0412 \u00a7f" + this.name + "\u00a77 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u043f\u043e\u0434\u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u00a7f" + subcommand.name);
        }
        return this;
    }

    public void register() {
        if (this.isSubcommand) {
            return;
        }
        if (this.debug != DebugMode.NONE) {
            this.updateDebug(this.debug);
        }
        if (this.permissions == null) {
            this.permissions = new DefaultPermissionGenerationStrategy();
        }
        if (this.color == null) {
            this.color = DefaultColorGenerationStrategy.INSTANCE;
        }
        this.updatePermissions(this.permission);
        CommandsAPI.getPlatform().registerCommand(this);
    }

    public void clearArgumentSets() {
        this.argumentSets.clear();
    }

    public Command help(Help help) {
        this.help = help;
        return this;
    }

    public Command description(String shortDescription) {
        this.description = shortDescription;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Command debug(DebugMode mode) {
        this.debug = mode;
        return this;
    }

    public Command getRootCommand() {
        if (this.isSubcommand) {
            return this.parent.getRootCommand();
        }
        return this;
    }

    public ColorGenerationStrategy getColorScheme() {
        if (this.color == null) {
            return this.parent.getColorScheme();
        }
        return this.color;
    }

    public Command setColorScheme(ColorGenerationStrategy colorGenerationStrategy) {
        this.color = colorGenerationStrategy;
        return this;
    }

    public Command setColorScheme(TextColor color) {
        this.setColorScheme(new ColoredScheme(color));
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Command setName(String name) {
        if (this.isSubcommand) {
            this.name = name;
        }
        return this;
    }

    @Override
    public String getPermission() {
        return this.permission;
    }

    PermissionGenerationStrategy getPermissions() {
        if (this.permissions == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getPermissions();
        }
        return this.permissions;
    }

    public Command setPermissions(PermissionGenerationStrategy strategy) {
        this.permissions = strategy;
        return this;
    }

    public Command canExecute(Predicate<Sender> canExecute) {
        this.preconditions.add(new PredicatePrecondition(canExecute));
        return this;
    }

    public Command preconditions(Precondition ... preconditions) {
        this.preconditions.addAll(Arrays.asList(preconditions));
        return this;
    }

    protected void updatePermissions(String permissions) {
        ProcessResult result;
        if (this.isSubcommand) {
            result = this.getPermissions().processSubCommand(permissions, this.permission, this.name);
            if (this.debug.is(DebugMode.DETAILED)) {
                this.debug.print("\u00a77\u041f\u043e\u0434\u043a\u043e\u043c\u0430\u043d\u0434\u0435 \u00a7f" + this.name + " \u00a77\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043f\u0440\u0430\u0432\u0430 \u00a7f" + result.getPermission());
            }
        } else {
            result = this.getPermissions().processCommand(this.permission, this.name);
            if (this.debug.is(DebugMode.DETAILED)) {
                this.debug.print("\u00a77\u041a\u043e\u043c\u0430\u043d\u0434\u0435 \u00a7f" + this.name + " \u00a77\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043f\u0440\u0430\u0432\u0430 \u00a7f" + result.getPermission());
            }
        }
        permissions = result.getNextPermissions();
        this.permission = result.getPermission();
        this.updatePermissionPrecondition();
        for (Command subcommand : this.subcommands) {
            subcommand.updatePermissions(permissions);
        }
        for (ArgumentSet argumentSet : this.argumentSets) {
            argumentSet.permission = this.getPermissions().processArgumentSet(permissions, argumentSet.permission, this.permission);
            argumentSet.updatePermissionPrecondition();
            if (!this.debug.is(DebugMode.DETAILED)) continue;
            this.debug.print("\u00a77\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0441\u0435\u0442\u0443 \u00a7f" + permissions + "/" + argumentSet + " \u00a77\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043f\u0440\u0430\u0432\u0430 \u00a7f" + argumentSet.permission);
        }
    }

    private void updatePermissionPrecondition() {
        for (Precondition precondition : this.preconditions) {
            if (!(precondition instanceof PermissionPrecondition)) continue;
            return;
        }
        this.preconditions.addFirst(new PermissionPrecondition(this));
    }

    protected void onExecute(Sender sender, String[] args, ArgumentSet founded) {
        long start = System.nanoTime();
        founded.execute(sender, args, this);
        if (this.debug.is(DebugMode.REDUCED)) {
            this.debug.print("\u00a77\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u00a7f" + founded + " \u0437\u0430\u043d\u044f\u043b\u043e \u00a7f" + (System.nanoTime() - start) + "ns \u00a77(" + (System.nanoTime() - start) / 1000000L + "ms)");
        }
    }

    protected List<Command> getSubcommandsFor(Sender sender, PreconditionRequirements requirements) {
        ArrayList<Command> list = new ArrayList<Command>();
        for (Command command : this.subcommands) {
            if (!command.checkPreconditions(sender, requirements)) continue;
            list.add(command);
        }
        return list;
    }

    protected boolean canPerformedBy(Sender sender) {
        return this.checkPreconditions(sender).getResult().canPerform();
    }

    protected CommandPreconditionResult checkPreconditions(Sender sender) {
        return new CommandPreconditionResult(this, PreconditionProcessor.process(sender, this.preconditions));
    }

    protected boolean checkPreconditions(Sender sender, PreconditionRequirements requirements) {
        return PreconditionProcessor.process(sender, this.preconditions).isSatisfy(requirements);
    }

    protected Command getSubcommandFor(String arg, Sender sender) {
        for (Command command : this.subcommands) {
            if (!command.name.equalsIgnoreCase(arg) && !command.aliases.contains(arg) || !command.checkPreconditions(sender, PreconditionRequirements.CAN_PERFORM_AND_CAN_SEE)) continue;
            return command;
        }
        return null;
    }

    protected List<ArgumentSet> getArgumentSetsFor(Sender sender, PreconditionRequirements requirements) {
        ArrayList<ArgumentSet> list = new ArrayList<ArgumentSet>();
        for (ArgumentSet arg : this.argumentSets) {
            if (!arg.checkPreconditions(sender, requirements)) continue;
            list.add(arg);
        }
        return list;
    }

    protected ArgumentSearchResult searchForArgumentSet(Sender sender, String ... args) {
        ArgumentSearchResult result = new ArgumentSearchResult();
        for (ArgumentSet set : this.argumentSets) {
            PreconditionResult preconditionResult = set.checkPreconditions(sender);
            ArgumentFitnessResult fitnessResult = set.isArgumentsFit(sender, args);
            String errorMessage = null;
            if (!preconditionResult.canPerform()) {
                if (preconditionResult.getCannotPerformMessage() == null) continue;
                errorMessage = preconditionResult.getCannotPerformMessage();
            }
            if (fitnessResult.success()) {
                if (errorMessage == null) {
                    return result.founded(set);
                }
                return result.error(set, errorMessage);
            }
            if (!preconditionResult.canSee()) continue;
            result.add(fitnessResult);
        }
        return result;
    }

    protected void onError(Sender sender, String label, String[] args, ArgumentSearchResult argumentSearchResult) {
        if (argumentSearchResult.getErrorMessage() != null) {
            this.showErrorMessage(sender, label, argumentSearchResult);
        } else if (argumentSearchResult.canShowDetailedHelp()) {
            this.showDetailedHelp(sender, label, argumentSearchResult);
        } else {
            this.showFullHelp(sender, label, args);
        }
    }

    private void showErrorMessage(Sender sender, String label, ArgumentSearchResult argumentSearchResult) {
        ArrayList<Component> toSend = new ArrayList<Component>();
        toSend.add(Component.empty());
        toSend.add(argumentSearchResult.getFounded().toComponent(sender, this.getColorScheme()));
        toSend.add(((TextComponent)Component.text("\u21b3 ").append(Component.text(argumentSearchResult.getErrorMessage()))).color(this.getColorScheme().accent(true)));
        toSend.add(Component.empty());
        for (Component line : toSend) {
            sender.sendMessage(line);
        }
    }

    protected void showFullHelp(Sender sender, String label, String[] args) {
        if (this.help == null) {
            this.sendAutoHelp(sender, label, args);
        } else {
            this.help.sendTo(sender, this, label, args);
        }
    }

    private void updateDebug(DebugMode debug) {
        this.debug = debug;
        for (Command subcommand : this.subcommands) {
            subcommand.updateDebug(debug);
        }
    }

    private void showDetailedHelp(Sender sender, String label, ArgumentSearchResult argumentSearchResult) {
        TextComponent written = Component.text(this.getFullCommandPath(label), this.getColorScheme().written(true));
        ArrayList<Component> toSend = new ArrayList<Component>();
        toSend.add(Component.empty());
        for (ArgumentFitnessResult invalidResult : argumentSearchResult.getInvalidResults()) {
            toSend.add(written.append(invalidResult.getArgumentSet().toComponent(sender, this.getColorScheme())));
            toSend.add(((TextComponent)Component.text("\u21b3 ").append(invalidResult.getInvalidArgument().invalidMessage(this, sender, invalidResult.getInvalidStringArgument()))).color(this.getColorScheme().accent(true)));
            toSend.add(Component.empty());
        }
        for (Component row : toSend) {
            sender.sendMessage(row);
        }
    }

    private void sendAutoHelp(Sender sender, String label, String[] args) {
        ColorGenerationStrategy color = this.getColorScheme();
        TextComponent written = Component.text(this.getFullCommandPath(label));
        ArrayList<Component> toSend = new ArrayList<Component>();
        for (Command subcommand : this.getSubcommandsFor(sender, PreconditionRequirements.ONLY_CAN_SEE)) {
            boolean canPerformedBy = subcommand.canPerformedBy(sender);
            toSend.add(written.color(color.written(canPerformedBy)).append(Component.text(" " + subcommand.name + " ", color.subcommand(canPerformedBy))).append(sender.isOp() ? Component.text(subcommand.permission, color.permissions(canPerformedBy)) : Component.empty()));
        }
        boolean previousWasEmptyLine = false;
        for (ArgumentSet argumentSet : this.filterArgumentSets(this.getArgumentSetsFor(sender, PreconditionRequirements.ONLY_CAN_SEE), args)) {
            if (argumentSet.isHidden()) continue;
            boolean canPerformedBy = argumentSet.canPerformedBy(sender);
            boolean hasHelp = argumentSet.hasHelp();
            if (!previousWasEmptyLine && hasHelp) {
                toSend.add(Component.empty());
            }
            toSend.add(written.color(color.written(canPerformedBy)).append(argumentSet.toComponent(sender, color)));
            if (hasHelp) {
                toSend.add(((TextComponent)Component.text("\u21b3 ").append(argumentSet.help)).color(color.accent(canPerformedBy)));
                toSend.add(Component.empty());
                previousWasEmptyLine = true;
                continue;
            }
            previousWasEmptyLine = false;
        }
        this.sendDescription(sender, color);
        sender.sendMessage("");
        if (toSend.isEmpty()) {
            sender.sendMessage(Component.text("\u0414\u043b\u044f \u0432\u0430\u0441 \u043d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u0439 \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b", color.main()));
        } else {
            sender.sendMessage(Component.text("\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b:", color.main()));
            sender.sendMessage("");
            for (Component row : toSend) {
                sender.sendMessage(row);
            }
        }
    }

    private List<ArgumentSet> filterArgumentSets(List<ArgumentSet> argumentSets, String[] args) {
        if (args.length == 0) {
            return argumentSets;
        }
        List<ArgumentSet> relevantArgumentSets = argumentSets.stream().filter(x -> x.shouldShowInHelp(List.of(args))).collect(Collectors.toList());
        if (relevantArgumentSets.isEmpty()) {
            return argumentSets;
        }
        return relevantArgumentSets;
    }

    private void sendDescription(Sender sender, ColorGenerationStrategy color) {
        if (this.description != null) {
            sender.sendMessage("");
            sender.sendMessage(Component.text("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435:", color.main()));
            boolean firstLine = true;
            for (String part : this.description.split("\n")) {
                sender.sendMessage(Component.text((firstLine ? "\u21b3 " : "  ") + part, color.accent(true)));
                firstLine = false;
            }
        }
    }

    @NotNull
    private String getFullCommandPath(String label) {
        StringBuilder writtenString = new StringBuilder();
        Command rootCommand = this;
        while (rootCommand.isSubcommand) {
            writtenString.insert(0, " " + rootCommand.name);
            rootCommand = rootCommand.parent;
        }
        writtenString.insert(0, "  /" + label);
        return writtenString.toString();
    }

    private int getCommandPathLength() {
        int length = 0;
        Command parent = this;
        while (parent != null) {
            ++length;
            parent = parent.parent;
        }
        return length;
    }
}

