/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.arguments.basic;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.CompletionStyle;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.cwutils.numbers.NumbersUtils;

public class IntegerArg
extends Argument {
    int min = Integer.MIN_VALUE;
    int max = Integer.MAX_VALUE;
    CompletionStyle style = CompletionStyle.PLACEHOLDER;
    String placeholder = "\u0426\u0435\u043b\u043e\u0435 \u0447\u0438\u0441\u043b\u043e";

    public IntegerArg() {
    }

    public IntegerArg(String placeholder) {
        this.placeholder = placeholder;
    }

    public IntegerArg setMin(int min2) {
        this.min = min2;
        return this;
    }

    public IntegerArg setMax(int max) {
        this.max = max;
        return this;
    }

    public IntegerArg setStyle(CompletionStyle style) {
        this.style = style;
        return this;
    }

    public IntegerArg setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    @Override
    public boolean valid(String raw) {
        try {
            if (!NumbersUtils.isInteger(raw)) {
                return false;
            }
            int parsed = Integer.parseInt(raw);
            return parsed >= this.min && parsed < this.max;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public List<String> completions(Sender sender) {
        switch (this.style) {
            case PLACEHOLDER: {
                return Collections.singletonList(this.placeholder);
            }
            case DIAPASON: {
                return Collections.singletonList(this.min + " -> " + this.max);
            }
            case LIST: {
                return IntStream.range(this.min, this.max).limit(1000L).mapToObj(Integer::toString).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    @Override
    public String argumentName() {
        return this.placeholder;
    }

    @Override
    public Object map() {
        return this.toInt();
    }

    @Override
    protected String hint() {
        boolean minFlag;
        StringBuilder builder = new StringBuilder();
        boolean bl = minFlag = this.min != Integer.MIN_VALUE;
        if (minFlag) {
            builder.append("\u041e\u0442 ").append(this.min);
        }
        if (this.max != Integer.MAX_VALUE) {
            builder.append(minFlag ? " \u0434\u043e " : "\u0414\u043e ").append(this.max);
        }
        return builder.toString();
    }
}

