/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.arguments.basic;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.CompletionStyle;
import ru.cwcode.commands.api.Sender;

public class StringArg
extends Argument {
    static final int INITIAL_MAX_STRING_LENGTH = 10000;
    protected String placeholder = "\u0442\u0435\u043a\u0441\u0442";
    int min = 1;
    int max = 10000;
    CompletionStyle style = CompletionStyle.PLACEHOLDER;
    Pattern pattern;

    public StringArg(String placeholder) {
        this.placeholder = placeholder;
    }

    public StringArg() {
    }

    public StringArg setMin(int min2) {
        this.min = min2;
        return this;
    }

    public StringArg setMax(int max) {
        this.max = max;
        return this;
    }

    public StringArg setStyle(CompletionStyle style) {
        this.style = style;
        return this;
    }

    public StringArg setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    public StringArg setPattern(Pattern pattern) {
        this.pattern = pattern;
        return this;
    }

    @Override
    public boolean valid(String raw) {
        if (raw.length() < this.min || raw.length() > this.max) {
            return false;
        }
        return this.pattern == null || this.pattern.matcher(raw).matches();
    }

    public List<String> completions(Sender sender) {
        switch (this.style) {
            case PLACEHOLDER: {
                return Collections.singletonList(this.placeholder);
            }
            case DIAPASON: {
                return Collections.singletonList("\u0421\u0442\u0440\u043e\u043a\u0430 \u043e\u0442 " + this.min + " \u0434\u043e " + this.max + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432 " + (this.pattern == null ? "" : this.pattern.toString()));
            }
        }
        return Collections.emptyList();
    }

    @Override
    public String argumentName() {
        return this.placeholder;
    }

    @Override
    protected String hint() {
        if (this.pattern != null) {
            return this.pattern.pattern();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\u041e\u0442 ").append(this.min);
        if (this.max != 10000) {
            builder.append(" \u0434\u043e ").append(this.max);
        }
        builder.append(" \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
        return builder.toString();
    }
}

