/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.paperplatform.argument;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.api.Sender;

public class OnlinePlayerWithPermissionArg
extends Argument {
    String permission;
    String argumentName = null;

    public OnlinePlayerWithPermissionArg(String permission) {
        this.permission = permission;
    }

    public OnlinePlayerWithPermissionArg(String permission, String argumentName) {
        this.permission = permission;
        this.argumentName = permission;
    }

    @Override
    public boolean valid(String raw) {
        Player player = Bukkit.getPlayer((String)raw);
        return player != null && player.hasPermission(this.permission) || player.isOp() && this.permission.equals("*");
    }

    public List<String> completions(Sender sender) {
        ArrayList<String> list = new ArrayList<String>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission(this.permission)) continue;
            list.add(player.getName());
        }
        return list;
    }

    @Override
    public String argumentName() {
        return this.argumentName == null ? "\u0418\u0433\u0440\u043e\u043a \u0441 " + this.permission : this.argumentName;
    }

    @Override
    public Object map() {
        return Bukkit.getPlayer((String)this.raw);
    }
}

