/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.paperplatform.paper;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import ru.cwcode.commands.Command;
import ru.cwcode.commands.api.CommandsAPI;
import ru.cwcode.commands.api.Logger;
import ru.cwcode.commands.api.Platform;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.commands.paperplatform.paper.PaperCommand;
import ru.cwcode.commands.paperplatform.paper.PaperLogger;
import ru.cwcode.commands.paperplatform.paper.PaperSender;
import ru.cwcode.cwutils.collections.CollectionUtils;
import ru.cwcode.cwutils.messages.MessageReturn;
import ru.cwcode.cwutils.messages.TargetableMessageReturn;
import ru.cwcode.cwutils.reflection.ReflectionUtils;

public class PaperPlatform
extends Platform {
    private final Logger logger = new PaperLogger();

    @Override
    public void registerCommand(Command command) {
        PluginCommand pluginCommand = Bukkit.getPluginCommand((String)command.getName());
        if (pluginCommand == null) {
            this.logger.warn("\u041a\u043e\u043c\u0430\u043d\u0434\u0430 `" + command.getName() + "` \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u043f\u043e \u043f\u0440\u0438\u0447\u0438\u043d\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u044f \u0432 plugin.yml");
            return;
        }
        PaperCommand paperCommand = new PaperCommand(command);
        pluginCommand.setExecutor((CommandExecutor)paperCommand.getCommandParser());
        pluginCommand.setTabCompleter((TabCompleter)paperCommand.getTabCompleter());
        CommandMap commandMap = ReflectionUtils.getFieldValue(Bukkit.getPluginManager(), "commandMap", CommandMap.class);
        Plugin plugin = pluginCommand.getPlugin();
        if (!command.aliases().isEmpty()) {
            command.aliases(new ArrayList<String>(CollectionUtils.combine(pluginCommand.getAliases(), command.aliases())));
            this.registerNewAliases(command, (org.bukkit.command.Command)pluginCommand, commandMap, plugin);
        }
        if (pluginCommand.getDescription().isEmpty()) {
            pluginCommand.setDescription(command.description());
        }
        if (pluginCommand.getPermission() == null) {
            pluginCommand.setPermission(command.getPermission());
        }
    }

    private void registerNewAliases(Command command, org.bukkit.command.Command paperCommand, CommandMap commandMap, Plugin plugin) {
        try {
            Field activeAliases = paperCommand.getClass().getSuperclass().getDeclaredField("activeAliases");
            activeAliases.setAccessible(true);
            ((List)activeAliases.get(paperCommand)).addAll(command.aliases());
            Field aliasesField = paperCommand.getClass().getSuperclass().getDeclaredField("aliases");
            aliasesField.setAccessible(true);
            ((List)aliasesField.get(paperCommand)).addAll(command.aliases());
            Method registerAlias = commandMap.getClass().getMethod("register", String.class, org.bukkit.command.Command.class);
            registerAlias.setAccessible(true);
            registerAlias.invoke((Object)commandMap, plugin.getName(), paperCommand);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0430\u043b\u0438\u0430\u0441\u044b \u0434\u043b\u044f `" + command.getName() + "`");
        }
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void handleExecutionException(Exception exception, Command command, Sender sender) {
        if (exception instanceof MessageReturn) {
            MessageReturn messageReturn = (MessageReturn)exception;
            if (messageReturn.isStyled()) {
                sender.sendMessage(messageReturn.getComponentMessage());
            } else {
                sender.sendMessage(messageReturn.getComponentMessage().color(command.getColorScheme().main()));
            }
            return;
        }
        if (exception instanceof TargetableMessageReturn) {
            sender.sendMessage(((TargetableMessageReturn)exception).getMessage(((PaperSender)sender).getCommandSender()));
            return;
        }
        String localizedMessage = exception.getLocalizedMessage();
        if (localizedMessage == null) {
            localizedMessage = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430";
        }
        sender.sendMessage(Component.text(localizedMessage, command.getColorScheme().main()));
        CommandsAPI.getPlatform().getLogger().warn("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 " + this.getClass().getName());
        exception.printStackTrace();
    }
}

