/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.player;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.plugin.java.JavaPlugin;
import ru.cwcode.cwutils.files.FileUtils;

public class PlayerFaceResolver {
    private final JavaPlugin plugin;
    private String filler = "\u2b1b";

    public PlayerFaceResolver(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void setFiller(String filler) {
        this.filler = filler;
    }

    public List<Component> getHeadLines(String name) {
        ArrayList<Component> list = new ArrayList<Component>();
        BufferedImage img = this.getPlayerFace(name);
        for (int h2 = 0; h2 < img.getHeight(); ++h2) {
            TextComponent text = Component.empty();
            for (int w = 0; w < img.getWidth(); ++w) {
                text = (TextComponent)text.append(Component.text(this.filler, TextColor.color(img.getRGB(w, h2))));
            }
            list.add(text);
        }
        return list;
    }

    public BufferedImage getPlayerFace(String name) {
        File file = this.resolveFile(name);
        try {
            if (file.exists()) {
                return ImageIO.read(file);
            }
            this.downloadHead(name);
            return ImageIO.read(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void downloadHead(String name) throws IOException {
        FileUtils.downloadFileTo("https://minotar.net/helm/" + name + "/8", this.resolvePath(name));
    }

    public CompletableFuture<List<Component>> getHeadLinesCompletable(String name) {
        return CompletableFuture.supplyAsync(() -> this.getHeadLines(name));
    }

    public CompletableFuture<BufferedImage> getPlayerFaceCompletable(String name) {
        return CompletableFuture.supplyAsync(() -> this.getPlayerFace(name));
    }

    String resolvePath(String name) {
        return this.plugin.getDataFolder().toPath().resolve("heads").resolve(name + ".png").toAbsolutePath().toString();
    }

    File resolveFile(String name) {
        Path path = this.plugin.getDataFolder().toPath().resolve("heads").resolve(name + ".png");
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                com.google.common.io.Files.createParentDirs((File)path.toFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return path.toFile();
    }
}

