/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.reflection;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ReflectionUtils {
    public static <T> T getNewInstance(Class<T> type, Object ... parameters) {
        try {
            Class[] classes = new Class[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                classes[i] = parameters[i].getClass();
            }
            Constructor<T> constructor = type.getConstructor(classes);
            constructor.setAccessible(true);
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T getFieldValue(Object object, String fieldName, Class<T> fieldType) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return fieldType.cast(field.get(object));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Set<Class<?>> getClasses(File jarFile, String packageName) {
        return ReflectionUtils.getClasses(jarFile, packageName, name -> true);
    }

    public static Set<Class<?>> getClasses(File jarFile, String packageName, Predicate<String> filter) {
        HashSet classes = new HashSet();
        try {
            JarFile file = new JarFile(jarFile);
            Enumeration<JarEntry> entry = file.entries();
            while (entry.hasMoreElements()) {
                JarEntry jarEntry = entry.nextElement();
                String name = jarEntry.getName().replace("/", ".");
                if (!name.startsWith(packageName) || !name.endsWith(".class") || !filter.test(name)) continue;
                classes.add(Class.forName(name.substring(0, name.length() - 6)));
            }
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static boolean tryToInvokeStaticMethod(Class<?> classInfo, String methodName) {
        try {
            Method load = classInfo.getDeclaredMethod(methodName, new Class[0]);
            if (!Modifier.isStatic(load.getModifiers()) || load.getParameterCount() != 0) {
                return false;
            }
            load.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
        return true;
    }
}

