/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.player;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class PlayerUtils {
    public static void safeGive(Player player, ItemStack item) {
        HashMap noSpace = player.getInventory().addItem(new ItemStack[]{item});
        for (ItemStack toDrop : noSpace.values()) {
            player.getWorld().dropItem(player.getLocation(), toDrop);
        }
    }

    public static boolean removeItems(Player player, ItemStack itemStack, int amount) {
        if (PlayerUtils.getItemAmount(player, itemStack) >= amount) {
            PlayerUtils.clearItemsForce(player, itemStack, amount);
            return true;
        }
        return false;
    }

    public static int getItemAmount(Player player, ItemStack itemStack) {
        int count = 0;
        for (int i = 0; i < player.getInventory().getSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack == null || !itemStack.isSimilar(stack)) continue;
            count += stack.getAmount();
        }
        return count;
    }

    public static void clearItemsForce(Player player, ItemStack itemStack, int amount) {
        for (int i = 0; i < player.getInventory().getSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack == null || !itemStack.isSimilar(stack)) continue;
            if (stack.getAmount() == 0) break;
            if (stack.getAmount() <= amount) {
                amount -= stack.getAmount();
                stack.setAmount(-1);
            }
            if (stack.getAmount() <= amount) continue;
            stack.setAmount(stack.getAmount() - amount);
            amount = 0;
        }
    }

    public static boolean removeItems(Player player, Material material, int amount) {
        if (PlayerUtils.getItemAmount(player, material) >= amount) {
            PlayerUtils.clearItemsForce(player, material, amount);
            return true;
        }
        return false;
    }

    public static int getItemAmount(Player player, Material material) {
        int count = 0;
        for (int i = 0; i < player.getInventory().getSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack == null || stack.getType() != material) continue;
            count += stack.getAmount();
        }
        return count;
    }

    public static void clearItemsForce(Player player, Material material, int amount) {
        for (int i = 0; i < player.getInventory().getSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack == null || material != stack.getType()) continue;
            if (stack.getAmount() == 0) break;
            if (stack.getAmount() <= amount) {
                amount -= stack.getAmount();
                stack.setAmount(-1);
            }
            if (stack.getAmount() <= amount) continue;
            stack.setAmount(stack.getAmount() - amount);
            amount = 0;
        }
    }

    public static List<LivingEntity> getNearbyLivingEntities(Player player, double radius) {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (LivingEntity x : player.getLocation().getNearbyLivingEntities(radius)) {
            if (x.equals((Object)player)) continue;
            list.add(x);
        }
        return list;
    }

    public static Optional<LivingEntity> getNearbyLivingEntity(Player player, double radius) {
        boolean seen = false;
        LivingEntity best = null;
        Comparator<LivingEntity> comparator = Comparator.comparingDouble(c -> player.getLocation().distance(c.getLocation()));
        for (LivingEntity x : player.getLocation().getNearbyLivingEntities(radius)) {
            if (x.equals((Object)player) || seen && comparator.compare(x, best) >= 0) continue;
            seen = true;
            best = x;
        }
        return seen ? Optional.of(best) : Optional.empty();
    }

    public static <T extends Entity> List<T> getNearbyEntities(Class<T> type, Player player, double radius) {
        if (type == Player.class) {
            ArrayList<Entity> list = new ArrayList<Entity>();
            for (Entity x : player.getWorld().getNearbyEntitiesByType(type, player.getLocation(), radius)) {
                if (x == player) continue;
                list.add(x);
            }
            return list;
        }
        return new ArrayList(player.getWorld().getNearbyEntitiesByType(type, player.getLocation(), radius));
    }

    public static void pushItemToPlayer(Player player, Item item, JavaPlugin plugin) {
        item.setVelocity(new Vector(0.0, 0.45, 0.0));
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> item.setVelocity(player.getLocation().add(0.0, 1.35, 0.0).subtract(item.getLocation()).toVector().normalize().multiply(0.65)), 5L);
    }

    public static String getTextureValue(PlayerProfile playerProfile) {
        String value = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDVhZGI2ZmZhMmM1YzBlMzUwYzI4NDk5MTM4YTU1NjY0NDFkN2JjNTczZGUxOTg5ZmRlMjEyZmNiMTk2NjgyNiJ9fX0=";
        if (playerProfile != null) {
            for (ProfileProperty profileProperty : playerProfile.getProperties()) {
                if (!profileProperty.getName().equals("textures")) continue;
                value = profileProperty.getValue();
            }
        }
        return value;
    }

    public static void setMainItemCooldown(Player player, int ticks) {
        player.setCooldown(player.getInventory().getItemInMainHand().getType(), ticks);
    }

    public static boolean isMainItemCooldown(Player player) {
        return player.hasCooldown(player.getInventory().getItemInMainHand().getType());
    }

    public static boolean isTargeting(Player player, Location target, double expand, double distance) {
        Location eyeLocation = player.getEyeLocation();
        BoundingBox boundingBox = new BoundingBox(target.getX(), target.getY(), target.getZ(), target.getX(), target.getY(), target.getZ());
        boundingBox.expand(expand);
        RayTraceResult rayTraceResult = boundingBox.rayTrace(eyeLocation.toVector(), eyeLocation.getDirection(), distance);
        return rayTraceResult != null;
    }
}

