/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.querz.io.ExceptionBiFunction;
import net.querz.io.MaxDepthIO;
import net.querz.nbt.io.NBTInput;
import net.querz.nbt.io.NamedTag;
import net.querz.nbt.tag.ByteArrayTag;
import net.querz.nbt.tag.ByteTag;
import net.querz.nbt.tag.CompoundTag;
import net.querz.nbt.tag.DoubleTag;
import net.querz.nbt.tag.EndTag;
import net.querz.nbt.tag.FloatTag;
import net.querz.nbt.tag.IntArrayTag;
import net.querz.nbt.tag.IntTag;
import net.querz.nbt.tag.ListTag;
import net.querz.nbt.tag.LongArrayTag;
import net.querz.nbt.tag.LongTag;
import net.querz.nbt.tag.ShortTag;
import net.querz.nbt.tag.StringTag;
import net.querz.nbt.tag.Tag;

public class NBTInputStream
extends DataInputStream
implements NBTInput,
MaxDepthIO {
    private static Map<Byte, ExceptionBiFunction<NBTInputStream, Integer, ? extends Tag<?>, IOException>> readers = new HashMap();
    private static Map<Byte, Class<?>> idClassMapping = new HashMap();

    private static void put(byte id, ExceptionBiFunction<NBTInputStream, Integer, ? extends Tag<?>, IOException> reader, Class<?> clazz) {
        readers.put(id, reader);
        idClassMapping.put(id, clazz);
    }

    public NBTInputStream(InputStream in) {
        super(in);
    }

    @Override
    public NamedTag readTag(int maxDepth) throws IOException {
        byte id = this.readByte();
        return new NamedTag(this.readUTF(), this.readTag(id, maxDepth));
    }

    @Override
    public Tag<?> readRawTag(int maxDepth) throws IOException {
        byte id = this.readByte();
        return this.readTag(id, maxDepth);
    }

    private Tag<?> readTag(byte type, int maxDepth) throws IOException {
        ExceptionBiFunction<NBTInputStream, Integer, Tag<?>, IOException> f = readers.get(type);
        if (f == null) {
            throw new IOException("invalid tag id \"" + type + "\"");
        }
        return f.accept(this, maxDepth);
    }

    private static ByteTag readByte(NBTInputStream in) throws IOException {
        return new ByteTag(in.readByte());
    }

    private static ShortTag readShort(NBTInputStream in) throws IOException {
        return new ShortTag(in.readShort());
    }

    private static IntTag readInt(NBTInputStream in) throws IOException {
        return new IntTag(in.readInt());
    }

    private static LongTag readLong(NBTInputStream in) throws IOException {
        return new LongTag(in.readLong());
    }

    private static FloatTag readFloat(NBTInputStream in) throws IOException {
        return new FloatTag(in.readFloat());
    }

    private static DoubleTag readDouble(NBTInputStream in) throws IOException {
        return new DoubleTag(in.readDouble());
    }

    private static StringTag readString(NBTInputStream in) throws IOException {
        return new StringTag(in.readUTF());
    }

    private static ByteArrayTag readByteArray(NBTInputStream in) throws IOException {
        ByteArrayTag bat = new ByteArrayTag(new byte[in.readInt()]);
        in.readFully((byte[])bat.getValue());
        return bat;
    }

    private static IntArrayTag readIntArray(NBTInputStream in) throws IOException {
        int l = in.readInt();
        int[] data = new int[l];
        IntArrayTag iat = new IntArrayTag(data);
        for (int i = 0; i < l; ++i) {
            data[i] = in.readInt();
        }
        return iat;
    }

    private static LongArrayTag readLongArray(NBTInputStream in) throws IOException {
        int l = in.readInt();
        long[] data = new long[l];
        LongArrayTag iat = new LongArrayTag(data);
        for (int i = 0; i < l; ++i) {
            data[i] = in.readLong();
        }
        return iat;
    }

    private static ListTag<?> readListTag(NBTInputStream in, int maxDepth) throws IOException {
        byte listType = in.readByte();
        ListTag<?> list = ListTag.createUnchecked(idClassMapping.get(listType));
        int length = in.readInt();
        if (length < 0) {
            length = 0;
        }
        for (int i = 0; i < length; ++i) {
            list.addUnchecked(in.readTag(listType, in.decrementMaxDepth(maxDepth)));
        }
        return list;
    }

    private static CompoundTag readCompound(NBTInputStream in, int maxDepth) throws IOException {
        CompoundTag comp = new CompoundTag();
        int id = in.readByte() & 0xFF;
        while (id != 0) {
            String key = in.readUTF();
            Tag<?> element = in.readTag((byte)id, in.decrementMaxDepth(maxDepth));
            comp.put(key, element);
            id = in.readByte() & 0xFF;
        }
        return comp;
    }

    static {
        NBTInputStream.put((byte)0, (i, d) -> EndTag.INSTANCE, EndTag.class);
        NBTInputStream.put((byte)1, (i, d) -> NBTInputStream.readByte(i), ByteTag.class);
        NBTInputStream.put((byte)2, (i, d) -> NBTInputStream.readShort(i), ShortTag.class);
        NBTInputStream.put((byte)3, (i, d) -> NBTInputStream.readInt(i), IntTag.class);
        NBTInputStream.put((byte)4, (i, d) -> NBTInputStream.readLong(i), LongTag.class);
        NBTInputStream.put((byte)5, (i, d) -> NBTInputStream.readFloat(i), FloatTag.class);
        NBTInputStream.put((byte)6, (i, d) -> NBTInputStream.readDouble(i), DoubleTag.class);
        NBTInputStream.put((byte)7, (i, d) -> NBTInputStream.readByteArray(i), ByteArrayTag.class);
        NBTInputStream.put((byte)8, (i, d) -> NBTInputStream.readString(i), StringTag.class);
        NBTInputStream.put((byte)9, NBTInputStream::readListTag, ListTag.class);
        NBTInputStream.put((byte)10, NBTInputStream::readCompound, CompoundTag.class);
        NBTInputStream.put((byte)11, (i, d) -> NBTInputStream.readIntArray(i), IntArrayTag.class);
        NBTInputStream.put((byte)12, (i, d) -> NBTInputStream.readLongArray(i), LongArrayTag.class);
    }
}

