/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.extra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import ru.cwcode.commands.Command;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.commands.extra.RepositoryAccessor;
import ru.cwcode.commands.extra.builder.CommandBuilder;
import ru.cwcode.commands.extra.builder.CreateCommandBuilder;
import ru.cwcode.commands.extra.builder.DeleteCommandBuilder;
import ru.cwcode.commands.extra.builder.list.ListCommandBuilder;
import ru.cwcode.commands.extra.builder.update.UpdateCommandBuilder;

public class ExtraCommandBuilder<E, K, S extends Sender> {
    private final RepositoryAccessor<E, K, S> repositoryAccessor;
    private final List<CommandBuilder<E, K, S>> builders = new ArrayList<CommandBuilder<E, K, S>>();

    public ExtraCommandBuilder(RepositoryAccessor<E, K, S> repositoryAccessor) {
        this.repositoryAccessor = repositoryAccessor;
    }

    public static <E, S extends Sender> ExtraCommandBuilder<E, String, S> of(BiFunction<E, S, String> elementToKey, BiFunction<String, S, E> keyToElement, Function<S, Collection<String>> keys) {
        return new ExtraCommandBuilder<E, String, S>(new RepositoryAccessor<E, String, S>(elementToKey, keyToElement, s2 -> s2, s2 -> s2, keys));
    }

    public static <E, K, S extends Sender> ExtraCommandBuilder<E, K, S> of(BiFunction<E, S, K> elementToKey, BiFunction<K, S, E> keyToElement, Function<K, String> keyToString, Function<String, K> stringToKey, Function<S, Collection<K>> keys) {
        return new ExtraCommandBuilder<E, K, S>(new RepositoryAccessor<E, K, S>(elementToKey, keyToElement, keyToString, stringToKey, keys));
    }

    public <B extends CommandBuilder<E, K, S>> ExtraCommandBuilder<E, K, S> builder(Function<RepositoryAccessor<E, K, S>, B> builderCreator, Consumer<B> builder) {
        CommandBuilder b = (CommandBuilder)builderCreator.apply(this.repositoryAccessor);
        builder.accept(b);
        this.builders.add(b);
        return this;
    }

    public ExtraCommandBuilder<E, K, S> delete(Consumer<DeleteCommandBuilder<E, K, S>> builder) {
        return this.builder(DeleteCommandBuilder::new, builder);
    }

    public ExtraCommandBuilder<E, K, S> update(Consumer<UpdateCommandBuilder<E, K, S>> builder) {
        return this.builder(UpdateCommandBuilder::new, builder);
    }

    public ExtraCommandBuilder<E, K, S> create(Consumer<CreateCommandBuilder<E, K, S>> builder) {
        return this.builder(CreateCommandBuilder::new, builder);
    }

    public ExtraCommandBuilder<E, K, S> list(Consumer<ListCommandBuilder<E, K, S>> builder) {
        return this.builder(ListCommandBuilder::new, builder);
    }

    public Command build(String commandName) {
        Command command = new Command(commandName);
        this.builders.forEach(builder -> builder.register(command));
        return command;
    }
}

